#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: pipelines.py 10244 2017-09-03 06:25:56Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-09-03 14:25:56 +0800 (週日, 03 九月 2017) $
# $Revision: 10244 $

import requests
import json


from scrapy.pipelines.files import FilesPipeline
from scrapy.pipelines.images import ImagesPipeline
from scrapy.exceptions import DropItem
from scrapy import Request

class DownloaderPipeline(FilesPipeline):

    def file_path(self, request, response=None, info=None):
        fileName = request.url.split('/')[-1]
        return '%s' % (fileName)

        
    def handle_redirect(self, url):
        response = requests.head(url)
        if response.status_code == 302:
            url = response.headers["Location"]
        if response.status_code == 301:
            url = requests.head(
                response.headers["Location"]).headers["Location"]
        return url

    def get_media_requests(self, item, info):
        yield Request(self.handle_redirect(item['downloadUrl']))
        
    def item_completed(self, results, item, info):
        filePaths = [x['path'] for ok, x in results if ok]
        if not filePaths:
            with open('./error.txt', 'a+') as f:
                f.write(
                    'Error Download URL: %s, Template URL: %s\n' % 
                    (item['downloadUrl'], item['previewUrl']))
            raise DropItem("Item contains no files")
        item['filePath'] = filePaths[0]
        return item
        
class JsonWriterPipeline(object):

    def process_item(self, item, spider):
        with open('json/%s.json' % item['slug'], 'wb') as f:
            line = json.dumps(dict(item)) + "\n"
            f.write(line)
        return item
        
class ImgPipeline(ImagesPipeline):
    def file_path(self, request, response=None, info=None):
        fileName = request.url.split('/')[-1]
        return '%s' % (fileName)
        
    def get_media_requests(self,item,info):
        for url in item['imageUrl']:
            yield Request(url)
            
    def item_completed(self,results,item,info):
        imagePaths = [x['path'] for ok,x in results if ok]
        if not imagePaths:
            raise DropItem('Item contains no image')
        item['imagePath'] = imagePaths  
        return item