#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (�g��, 07 ���� 2017) $
# $Revision: 9948 $

import requests
import json

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.conf import settings
from django.utils.safestring import mark_safe
from django.template.loader import select_template

from Zephyrus.facebook import settings as zephyrusSettings
from Zephyrus.facebook.models import FacebookFan, FacebookPhoto


class FanPage(object):
    def __init__(self, id, createTime, msg, img, url):
        self.id = id
        self.createTime = createTime
        self.msg = msg
        self.img = img
        self.url = url
        
class Photo(object):
    def __init__(self, name, url, link):
        self.name = name
        self.url = url
        self.link = link
        
def getFanPageId(accessToken, url):
    # get fan page id
    fanPageUrl = url
    if not fanPageUrl.endswith('/'):
        fanPageUrl += '/'
    req = requests.get(
        ("https://graph.facebook.com/v2.8/%s?access_token=%s&debug=all"
         "&format=json&method=get&pretty=0&suppress_http_code=1") % (
         fanPageUrl, accessToken))
    text = req.text
    
    if 'id' in json.loads(text):
        fanPageId = json.loads(text)['id']
        return fanPageId
    else:
        return None

class FacebookFanPlugin(CMSPluginBase):
    model = FacebookFan
    module = "Zehpyrun Facebook"
    name = _("Facebook Fan Page")
    render_template = zephyrusSettings.ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            zephyrusSettings.ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        accessToken = '%s|%s' % (
            settings.SOCIAL_AUTH_FACEBOOK_KEY, 
            settings.SOCIAL_AUTH_FACEBOOK_SECRET
        )
        fanPageUrl = instance.url
        fanPageId = getFanPageId(accessToken, instance.url)
        
        if not fanPageId:
            # ��}�ݲŦX���T�榡
            context.update({
                'error': (u'\u7db2\u5740\u9700\u7b26\u5408\u6b63'
                          u'\u78ba\u683c\u5f0f,'
                          u'EX: https://www.facebook.com/xxx/'),
            })
            return context
        
        # get data
        query = "posts?fields=full_picture,message&limit=100" 
        req = requests.get(
            'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
            fanPageId, query, accessToken)
            )      
        content = json.loads(req.text)['data']
        
        # create objects
        fpList = []
        for data in content:
            msg = None
            img = None
            createdTime = None
            url = None
            id = None
            if 'message' in data:
                msg = mark_safe(data['message'].replace('\n', '<br />'))
            else:
                continue
            if 'full_picture' in data:
                img = data['full_picture']
            if 'created_time' in data:
                createdTime = data['created_time']
            if 'id' in data:
                index = data['id'].index('_')
                id = data['id'][index + 1:]
                url = '%sposts/%s' % (fanPageUrl, id)
            fpList.append(FanPage(id, createdTime, msg, img, url))
            if len(fpList) == instance.limit:
                break
        
        context.update({
            'fpList': fpList,
        })
        
        return context
        
class FacebookPhotoPlugin(CMSPluginBase):
    model = FacebookPhoto
    module = "Zehpyrun Facebook"
    name = _("Facebook Fan Photo")
    render_template = zephyrusSettings.ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            zephyrusSettings.ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        accessToken = '%s|%s' % (
            settings.SOCIAL_AUTH_FACEBOOK_KEY, 
            settings.SOCIAL_AUTH_FACEBOOK_SECRET
        )
        
        albumId = None
        fanPageId = getFanPageId(accessToken, instance.url)
        if 'album_id=' in instance.url:
            index = instance.url.index('album_id=') + len('album_id=')
            albumId = instance.url[index:]
        else:
            if not fanPageId:
                # ��}�ݲŦX���T�榡
                context.update({
                    'error': (u'\u7db2\u5740\u9700\u7b26\u5408\u6b63'
                            u'\u78ba\u683c\u5f0f,'
                            u'EX: https://www.facebook.com/pg/xxx/photos/'
                            u'?tab=album&album_id=xxx'),
                })
                return context

        if albumId:
            query = "?fields=photos.limit(100){name,images,link}"
            req = requests.get(
                'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
                albumId, query, accessToken)
                )
        else:
            query = ("photos/uploaded?fields=images,name,link&limit=%d" % 
                     instance.limit)
            if not fanPageId:
                # ��}�ݲŦX���T�榡
                context.update({
                    'error': (u'\u7db2\u5740\u9700\u7b26\u5408\u6b63'
                            u'\u78ba\u683c\u5f0f,'
                            u'EX: https://www.facebook.com/xxx/'),
                })
                return context
            req = requests.get(
                'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
	            fanPageId, query, accessToken)
            )     
        
        text = json.loads(req.text)
        
        if 'photos' in text and 'data' in text['photos']:
            content = text['photos']['data']
        elif 'data' in text:
            content = text['data']
        else:
            # �j�M�����ï���
            context.update({
                'error': u"\u641c\u5c0b\u4e0d\u5230\u76f8\u7c3f\u8cc7\u6599",
            })
            return context
                
        
        # create objects
        photoList = []
        for data in content:
            name = None
            url = None
            link = None
            if not 'images' in data:
                continue
            for data2 in data['images']:
                if 'source' in data2:
                    url = data2['source']
                    break
            if 'name' in data:
                name = mark_safe(data['name'].replace('\n', '<br />'))
            if 'link' in data:
                link = data['link']
            photoList.append(Photo(name, url, link))
            if len(photoList) == instance.limit:
                break
        
        context.update({
            'photoList': photoList,
        })
        
        return context

plugin_pool.register_plugin(FacebookFanPlugin)
plugin_pool.register_plugin(FacebookPhotoPlugin)