#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.template.loader import select_template
from aldryn_newsblog.models import Article

from Zephyrus.blog_extension import settings as _settings
from Zephyrus.blog_extension.models import MayLikePlugin

class MayLikeArticlePlugin(CMSPluginBase):
    model = MayLikePlugin
    module = 'News & Blog'
    name = _("May Like Articles")
    render_template =_settings.ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            _settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES,
        ])

    def render(self, context, instance, placeholder):
        queryset = Article.objects.all()

        if instance.tag:
            queryset = queryset.filter(tags__name__in=[instance.tag.name])
        if instance.catagory:
            queryset = queryset.filter(
                categories__in=[instance.catagory])

        if queryset.count() >= instance.limit:
            articles = queryset[:instance.limit]
        else:
            articles = queryset

        context.update({
            'articles': articles,
        })
        return context

plugin_pool.register_plugin(MayLikeArticlePlugin)