#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Amazon.py 12868 2021-04-28 20:10:26Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-04-29 04:10:26 +0800 (週四, 29 四月 2021) $
# $Revision: 12868 $

import boto3

from django.conf import settings

class SES(object):
    def __init__(self, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY):
        self.connection = boto3.client(
            'ses', 
            aws_access_key_id=AWS_ACCESS_KEY_ID, 
            aws_secret_access_key=AWS_SECRET_ACCESS_KEY, 
            region_name="us-east-1"
        )

    def getIdentityNotificationAttributes(self, email):
        result = self.connection.get_identity_notification_attributes(Identities=[email,])
        values = result.get("NotificationAttributes", {})
        return values

    def setIdentityNotificationTopic(self, notificationType, identity, topic):
        result = ses.set_identity_notification_topic(
            Identity=identity,
            NotificationType=notificationType,
            SnsTopic=topic
        )

    def getAllVerifiedSenders(self):
        result = self.connection.list_identities(IdentityType='EmailAddress')
        verifiedList = result.get('Identities', [])
        return verifiedList

    def verifyEmailAddress(self, email):
        result = self.connection.verify_email_identity(EmailAddress=email) 
        return result.get("ResponseMetadata")

    def deleteVerifiedEmailAddress(self, email):
        result = self.connection.delete_identity(Identity=email)
        return result.get("ResponseMetadata")

class SNS(object):
    def __init__(self, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY):
        self.connection = boto3.client(
            'sns', 
            aws_access_key_id=AWS_ACCESS_KEY_ID, 
            aws_secret_access_key=AWS_SECRET_ACCESS_KEY, 
            region_name="us-east-1"
        )

    def getAllTopicArns(self):
        allTopics = self.connection.list_topics()
        allTopics = allTopics['Topics']
        allTopics = [d['TopicArn'] for d in allTopics]
        return allTopics

    def createTopic(self, name):
        topic = self.connection.create_topic(Name=name)
        arn = topic['TopicArn']
        return arn

    def getAllSubscriptionsByTopic(self, topic):
        response = self.connection.list_subscriptions_by_topic(
            TopicArn=topic,
        )
        response = response['Subscriptions']
        return response

    def checkSubscriptionExist(self, topic, arnName):
        def getNameFromArn(arn):
            s = arn.split(':')
            return s[-1]

        for r in self.getAllSubscriptionsByTopic(topic):
            protocol = ['http', 'https']
            if r['Protocol'] in protocol:
                arn = getNameFromArn(r['TopicArn'])
                if arn == arnName:
                    return True
        return False

    def subscribe(self, topic, subscriptionType, link):
        if settings.SECURE_PROXY_SSL_HEADER:
            protocol = settings.SECURE_PROXY_SSL_HEADER[1]
        else:
            protocol = 'http'

        self.connection.subscribe(
            TopicArn=topic, 
            Protocol=protocol, 
            Endpoint=link,
        )