#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

from django.contrib import admin
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from django.core.management import call_command
from aldryn_newsblog.admin import ArticleAdmin
from aldryn_newsblog.models import Article
from djangocms_text_ckeditor.models import Text

class ArticleAdmin2(ArticleAdmin):
    fieldsets = (
        (None, {
            'fields': (
                'title',
                'author',
                'publishing_date',
                'is_published',
                'is_featured',
                'featured_image',
            )
        }),
        (_('Meta Options'), {
            'classes': ('collapse',),
            'fields': (
                'slug',
                'meta_title',
                'meta_description',
                'meta_keywords',
            )
        }),
        (_('Advanced Settings'), {
            'classes': ('collapse',),
            'fields': (
                'tags',
                'categories',
                'related',
                'owner',
                'app_config',
            )
        }),
    )

    def response_add(self, request, obj, post_url_continue=None):
        body = _("double click here to edit article content")
        textPlugin = Text.objects.create(
            placeholder=obj.content,
            language=obj.language_code,
            body=body, plugin_type='TextPlugin')

        call_command('update_index', noinput=True)
        return super(ArticleAdmin2, self).response_add(
            request, obj, post_url_continue=None)

admin.site.unregister(Article)
admin.site.register(Article, ArticleAdmin2)
