#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from django.db.models import Count
from django.template.loader import select_template

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from oscar.core.loading import get_model

from Zephyrus.cms_oscar import settings 
from Zephyrus.cms_oscar.models import OscarFeatured, OscarLatest
from Zephyrus.cms_oscar.forms import OscarFeaturedForm, OscarLatestForm


ProductRecord = get_model('analytics', 'ProductRecord')
Product = get_model('catalogue', 'Product')

if hasattr(Product, 'tags'):
    hasTags = True

class FeaturedPlugin(CMSPluginBase):
    model = OscarFeatured
    module = "Zephyrus Oscar"
    name = "Featured Products"
    render_template = settings.ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE
    form = OscarFeaturedForm

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            settings.ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        if hasTags:
            if instance.tag:
                queryset = ProductRecord.objects.filter(
                    product__tags__id__in=[instance.tag])
            else:
                queryset = ProductRecord.objects.all()
        else:
            queryset = ProductRecord.objects.all()
        

        if queryset.count() >= instance.limit:
            topViewProducts = \
                queryset.order_by('-num_views')[:instance.limit]
        else:
            topViewProducts = queryset.order_by('-num_views')
        products = [x.product for x in topViewProducts]
        context.update({
            'products': products,
        })
        
        return context

class LatestPlugin(CMSPluginBase):
    model = OscarLatest
    module = "Zephyrus Oscar"
    name = "Latest Products"
    render_template = settings.ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE
    form = OscarLatestForm

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            settings.ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        if hasTags:
            if instance.tag:
                queryset = Product.objects.filter(
                    tags__id__in=[instance.tag])
            else:
                queryset = Product.objects.all()
        else:
            queryset = ProductRecord.objects.all()

        if queryset.count() >= instance.limit:
            products = queryset.order_by('-date_updated')[:instance.limit]
        else:
            products = queryset.order_by('-date_updated')
        context.update({
            'products': products,
        })
        
        return context
    
plugin_pool.register_plugin(FeaturedPlugin)
plugin_pool.register_plugin(LatestPlugin)
