#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.core.validators import MaxValueValidator

from cms.models import CMSPlugin

from Zephyrus.facebook import settings

class FacebookFan(CMSPlugin):
    url = models.URLField()
    limit = models.PositiveIntegerField(default=100, 
        validators=[MaxValueValidator(100),])

    renderTemplate = models.CharField(
        _('Fan Template'), max_length=150, blank=True,
        choices=settings.ZEPHYRUS_FACEBOOK_FAN_TEMPLATES,
        default=settings.ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE,
    )

    # display:
    unknownDisplay = models.BooleanField(
        _('Display unknown article'), default=True)
    videoDisplay = models.BooleanField(
        _('Display video article'), default=True)
    albumDisplay = models.BooleanField(
        _('Display album photo article'), default=True)
    shareDisplay = models.BooleanField(
        _('Display share article'), default=True)
    commerceDisplay = models.BooleanField(
        _('Display commerce article'), default=True)

    onlyMessageDisplay = models.BooleanField(
        _('Only display article has message'), default=True)
    
class FacebookPhoto(CMSPlugin):
    url = models.URLField()
    limit = models.PositiveIntegerField(default=100,
        validators=[MaxValueValidator(100),])
    renderTemplate = models.CharField(
        _('Photo Template'), max_length=150, blank=True,
        choices=settings.ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES,
        default=settings.ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE,
    )

LAYOUT_CHOICE = (
    ('standard',  _("Standard")),
    ('button_count',  _("Button Count")),
    ('button',  _("Button")),
    ('box_count',  _("Box Count")),
)

ACTION_CHOICE = (
    ('like',  _("Like")),
    ('recommend',  _("Recommend")),
)

SIZE_CHOICE = (
    ('small',  _("Small")),
    ('large',  _("Large")),
)

class ShareLike(CMSPlugin):
    layout = models.CharField(
        _("Layout"),
        max_length=15,
        choices=LAYOUT_CHOICE,
        default='standard',
    )

    action = models.CharField(
        _("Action"),
        max_length=10,
        choices=ACTION_CHOICE,
        default='like',
    )

    size = models.CharField(
        _("Size"),
        max_length=5,
        choices=SIZE_CHOICE,
        default='small',
    )

    showFaces = models.BooleanField(_("Show faces"),)
    share = models.BooleanField(_("Share"),)
    appId = models.CharField(_("Facebook API app ID"), max_length=20)

    width = models.PositiveIntegerField(_("Width"), default=450)
    height = models.PositiveIntegerField(_("Height"), default=80)