#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11369 2019-02-19 13:16:39Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-02-19 22:16:39 +0900 (週二, 19 二月 2019) $
# $Revision: 11369 $

import os
import sys
import warnings
import json
import datetime
import urllib
import hashlib

from collections import OrderedDict

from Iuppiter.Encoding import utf8
from Iuno import warnWithout, update, require
from Iuppiter.DjangoUtil import (extendInstalledApps, 
                                 extendMiddlewareClasses, 
                                 extendTemplateContextProcessors,
                                 extendTemplateDirs, 
                                 extendDatabaseDefaults, 
                                 extendAuthenticationBackend)

from oscar import get_core_apps
from oscar import OSCAR_MAIN_TEMPLATE_DIR

from django.utils.translation import ugettext_lazy as _
from django.utils.translation import ugettext as _2
from django.core.urlresolvers import reverse

CKEDITOR_CONFIGS = {
    'default': {
        'skin': 'moono',
        # 'skin': 'office2013',
        'toolbar_Basic': [
            ['Source', '-', 'Bold', 'Italic']
        ],
        'toolbar_YourCustomToolbarConfig': [
            {'name': 'document', 'items': [
                'Source', '-', 'Save', 'NewPage', 
                'Preview', 'Print', '-', 'Templates']},
            {'name': 'clipboard', 'items': [
                'Cut', 'Copy', 'Paste', 'PasteText', 
                'PasteFromWord', '-', 'Undo', 'Redo']},
            {'name': 'editing', 'items': ['Find', 'Replace', '-', 'SelectAll']},
            {'name': 'forms',
             'items': ['Form', 'Checkbox', 'Radio', 'TextField', 
                       'Textarea', 'Select', 'Button', 'ImageButton',
                       'HiddenField']},
            '/',
            {'name': 'basicstyles',
             'items': ['Bold', 'Italic', 'Underline', 'Strike', 
                       'Subscript', 'Superscript', '-', 'RemoveFormat']},
            {'name': 'paragraph',
             'items': ['NumberedList', 'BulletedList', '-', 'Outdent', 
                       'Indent', '-', 'Blockquote', 'CreateDiv', '-',
                       'JustifyLeft', 'JustifyCenter', 'JustifyRight', 
                       'JustifyBlock', '-', 'BidiLtr', 'BidiRtl',
                       'Language']},
            {'name': 'links', 'items': ['Link', 'Unlink', 'Anchor']},
            {'name': 'insert',
             'items': ['Image', 'Flash', 'Table', 'HorizontalRule', 
                       'Smiley', 'SpecialChar', 'PageBreak', 'Iframe']},
            '/',
            {'name': 'styles', 'items': [
                'Styles', 'Format', 'Font', 'FontSize']},
            {'name': 'colors', 'items': ['TextColor', 'BGColor']},
            {'name': 'tools', 'items': ['Maximize', 'ShowBlocks']},
            {'name': 'about', 'items': ['About']},
            '/',  # put this to force next toolbar on new line
            {'name': 'yourcustomtools', 'items': [
                # put the name of your editor.ui.addButton here
                'Preview',
                'Maximize',

            ]},
        ],
        'toolbar': 'YourCustomToolbarConfig',  
        'tabSpaces': 4,
        'extraPlugins': ','.join([
            'uploadimage', # the upload image feature
            # your extra plugins here
            'div',
            'autolink',
            'autoembed',
            'embedsemantic',
            'autogrow',
            # 'devtools',
            'widget',
            'lineutils',
            'clipboard',
            'dialog',
            'dialogui',
            'elementspath'
        ]),
    }
}

def attachSettings(settingsDict, enablePaypal=False):
    """
    Attach default settings to settings.py.
    It must be called in settings by passing locals().

    @param settingsDict locals() in settings.py.
    @param enablePaypal enable pay with paypal or not
    """

    #=========================================================================
    # Django plugins.

    extraApps = []
    
    if 'IUNO_SHOP_EXTRA_APPS' in settingsDict:
        extraApps = settingsDict['IUNO_SHOP_EXTRA_APPS']

    ADDING_INSTALLED_APPS = (
        'django.contrib.sites',
        'django.contrib.flatpages',
        'widget_tweaks',
    ) + tuple(get_core_apps(extraApps))
    
    ADDING_INSTALLED_APPS += (
        'Iuno.shop',
        'ckeditor',
        'ckeditor_uploader',
    )
    
    ADDING_MIDDLEWARE_CLASSES = (
        'oscar.apps.basket.middleware.BasketMiddleware',
        'django.contrib.flatpages.middleware.FlatpageFallbackMiddleware',
    )

    installed = settingsDict['INSTALLED_APPS']
    keys = [k for k in installed if k.startswith('django.contrib')]
    extendInstalledApps(settingsDict, ADDING_INSTALLED_APPS,
                        key=list(keys)[-1])

    extendMiddlewareClasses(settingsDict, ADDING_MIDDLEWARE_CLASSES,
                            key='django.middleware.security.SecurityMiddleware')
    #=========================================================================
    
    #=========================================================================
    # Email.
    emailDefaults = {
        'ACCOUNT_EMAIL_CONFIRMATION_REQUIRED' : True,
    }

    update(settingsDict, emailDefaults)
    settingsDict['OSCAR_FROM_EMAIL'] = settingsDict['DEFAULT_FROM_EMAIL']
    #=========================================================================
    
    #=========================================================================
    # authentication backends.
    authenticationBackends = [            
        'django.contrib.auth.backends.ModelBackend',
        'oscar.apps.customer.auth_backends.EmailBackend',
    ]

    authenticationBackends = tuple(authenticationBackends)
    
    extendAuthenticationBackend(settingsDict, authenticationBackends)
    #=========================================================================
    
    #=========================================================================
    #  Django templates.
    #  Context processors
    ADDING_TEMPLATES_CONTEXT_PROCESSORS = (
        'oscar.apps.search.context_processors.search_form',
        'oscar.apps.promotions.context_processors.promotions',
        'oscar.apps.checkout.context_processors.checkout',
        'oscar.apps.customer.notifications.context_processors.notifications',
        'oscar.core.context_processors.metadata',                       
    )
    
    extendTemplateContextProcessors(settingsDict, 
                                    ADDING_TEMPLATES_CONTEXT_PROCESSORS)

    # Template tags
    ADDING_TEMPLATES_DIRS = [
        os.path.join(settingsDict['BASE_DIR'], 'templates'),
        OSCAR_MAIN_TEMPLATE_DIR,
    ]
    extendTemplateDirs(settingsDict, ADDING_TEMPLATES_DIRS)
    #=========================================================================
    # Django database default values.
    ADDING_DATABASES_DEFAULTS = {
        'ATOMIC_REQUESTS': True
    }
    extendDatabaseDefaults(settingsDict, ADDING_DATABASES_DEFAULTS)
    #=========================================================================
    # Django haystack connections.
    BASE_DIR = settingsDict['BASE_DIR']
    if settingsDict['DEBUG'] or sys.platform.startswith("win32"):
        ADDING_HAYSTACK_CONNECTIONS = {
            'HAYSTACK_CONNECTIONS': {
                'default': {
                    'ENGINE': (
                        'haystack.backends.whoosh_backend.WhooshEngine'),
                    'PATH': os.path.join(BASE_DIR, 'whoosh_index'),
                },
            },
        }
    else:
        ADDING_HAYSTACK_CONNECTIONS = {
            'HAYSTACK_CONNECTIONS': {
                'default': {
                    'ENGINE': 'xapian_backend.XapianEngine',
                    'PATH': os.path.join(BASE_DIR, 'xapian_index'),
                },
            },
        }
        
    update(settingsDict, ADDING_HAYSTACK_CONNECTIONS)
    #=========================================================================

    #=========================================================================
    # Static files setting for Iuno.shop
    location = lambda x: os.path.join(
        os.path.dirname(os.path.realpath(settingsDict['__file__'])), x)

    if settingsDict['DEBUG']:
        addStaticRoot = {
            'STATIC_ROOT': location('static')
        }
        update(settingsDict, addStaticRoot)
    elif settingsDict['DEBUG'] == False:
        ADD_STATICFILES_FINDERS = {
            'STATICFILES_FINDERS': [
                'django.contrib.staticfiles.finders.FileSystemFinder',
                'django.contrib.staticfiles.finders.AppDirectoriesFinder',
            ]
        }
        update(settingsDict, ADD_STATICFILES_FINDERS)

    #=========================================================================
    if 'OSCAR_DEFAULT_CURRENCY' not in settingsDict:
        settingsDict['OSCAR_DEFAULT_CURRENCY'] = 'USD'
    #=========================================================================
    # Oscar default settings 
    # __import__ 模組的用法與官方文件有落差，可能是使用時帶入參數有誤，
    # 先以目前的寫法帶過
    # see #2784
    addOscarDefaultsPackages = {}
    oscarDefaultsPackages = __import__(
            'oscar.defaults', globals(), locals(), [], -1
        ).__dict__['defaults']
    for attr in dir(oscarDefaultsPackages):
        addOscarDefaultsPackages[attr] = getattr(
            oscarDefaultsPackages, attr)
    update(settingsDict, addOscarDefaultsPackages)
    #=========================================================================

    #=========================================================================
    ecpayEnable = False
    if 'IUNO_SHOP_ECPAY_ENABLE' in settingsDict:
        ecpayEnable = settingsDict['IUNO_SHOP_ECPAY_ENABLE']

    allpayEnable = False
    if 'IUNO_SHOP_ALLPAY_ENABLE' in settingsDict:
        allpayEnable = settingsDict['IUNO_SHOP_ALLPAY_ENABLE']

    spgatewayEnable = False
    if 'IUNO_SHOP_SPGATEWAY_ENABLE' in settingsDict:
        spgatewayEnable = settingsDict['IUNO_SHOP_SPGATEWAY_ENABLE']

    cathaybkEnable = False
    if 'IUNO_SHOP_CATHAYBK_ENABLE' in settingsDict:
        cathaybkEnable = settingsDict['IUNO_SHOP_CATHAYBK_ENABLE']

    ADDING_OSCAR_DASHBOARD_NAVIGATION = {
        'label': _('Payment'),
        'icon': 'icon-globe',
        'children': [
           
        ]
    }

    if enablePaypal:
        require('PAYPAL_API_USERNAME', settingsDict)
        require('PAYPAL_API_PASSWORD', settingsDict)
        require('PAYPAL_API_SIGNATURE', settingsDict)

        ADDING_PAYPAL_INSTALLED_APPS = (
            'paypal',
        )
        extendInstalledApps(settingsDict, ADDING_PAYPAL_INSTALLED_APPS,
                        key=list(keys)[-1])


        ADDING_OSCAR_SHOP_TAGLINE = {
            'OSCAR_SHOP_TAGLINE' : 'Paypal'
        }
        update(settingsDict, ADDING_OSCAR_SHOP_TAGLINE)

        ADDING_OSCAR_DASHBOARD_NAVIGATION['children'].append({
            'label': _('Paypal transactions'),
            'url_name': 'paypal-express-list',
        })

    if ecpayEnable:
        ADDING_OSCAR_DASHBOARD_NAVIGATION['children'].append({
            'label': _('ECPay transactions'),
            'url_name': 'ecpayTransaction',
            'access_fn': \
                lambda user, url_name, url_args, url_kwargs: user.is_staff,
        })
        ADDING_OSCAR_DASHBOARD_NAVIGATION['children'].append({
            'label': _('ECPay logistic transactions'),
            'url_name': 'ecpayLogisticTransaction',
            'access_fn': \
                lambda user, url_name, url_args, url_kwargs: user.is_staff,
        })
    if allpayEnable:
        ADDING_OSCAR_DASHBOARD_NAVIGATION['children'].append({
            'label': _('AllPay transactions'),
            'url_name': 'allpayTransaction',
            'access_fn': \
                lambda user, url_name, url_args, url_kwargs: user.is_staff,
        })
    if spgatewayEnable:
        ADDING_OSCAR_DASHBOARD_NAVIGATION['children'].append({
            'label': _('Spgateway transactions'),
            'url_name': 'spgatewayTransaction',
            'access_fn': \
                lambda user, url_name, url_args, url_kwargs: user.is_staff,
        })
    if cathaybkEnable:
        ADDING_OSCAR_DASHBOARD_NAVIGATION['children'].append({
            'label': _('Cathay credit transactions'),
            'url_name': 'cathaybkCreditTransaction',
            'access_fn': \
                lambda user, url_name, url_args, url_kwargs: user.is_staff,
        })

    if enablePaypal or ecpayEnable or allpayEnable or spgatewayEnable:
        if 'OSCAR_DASHBOARD_NAVIGATION' in settingsDict:
            settingsDict['OSCAR_DASHBOARD_NAVIGATION'].append(
                ADDING_OSCAR_DASHBOARD_NAVIGATION)
        else:
            settingsDict['OSCAR_DASHBOARD_NAVIGATION'] = \
                                            ADDING_OSCAR_DASHBOARD_NAVIGATION
    #=========================================================================
    
    #=========================================================================
    # Django ckeditor settings
    DJANGO_CKEDITOR_CONF = {
        'CKEDITOR_UPLOAD_PATH': "uploads/",
        'CKEDITOR_CONFIGS': CKEDITOR_CONFIGS,
    }
    update(settingsDict, DJANGO_CKEDITOR_CONF)
    #=========================================================================

    #=========================================================================
    # Django order status settings
    allSettings = [
        'OSCAR_INITIAL_ORDER_STATUS',
        'OSCAR_INITIAL_LINE_STATUS',
        'OSCAR_ORDER_STATUS_PIPELINE',
        'OSCAR_PROCESSING_SEND_EMAIL_STATUS',
        'OSCAR_ARRIVE_SEND_EMAIL_STATUS',

        'OSCAR_ORDER_RETURN_STATUS',
        'OSCAR_ORDER_PROCESSING_STATUS',
        'OSCAR_ORDER_COMPLETE_STATUS',
        'OSCAR_ORDER_ARRIVE_STATUS',
    ]

    # add default settings
    needShipping = False
    if 'IUNO_SHOP_NEED_SHIPPING' in settingsDict:
        needShipping = settingsDict['IUNO_SHOP_NEED_SHIPPING']
    
    hasConfig = False
    for s in allSettings:
        if s in settingsDict:
             hasConfig = True
             break

    if not hasConfig:
        if needShipping:
            ADDING_OSCAR_ORDER_STATUS = {
                'OSCAR_PROCESSING_SEND_EMAIL_STATUS': u'商品送貨中',
                'OSCAR_ARRIVE_SEND_EMAIL_STATUS': u'商品已到貨',
                'OSCAR_INITIAL_ORDER_STATUS': u'等待處理中',
                'OSCAR_INITIAL_LINE_STATUS': '-',
                'OSCAR_ORDER_RETURN_STATUS': u'商品退貨中',
                'OSCAR_ORDER_PROCESSING_STATUS': u'商品送貨中',
                'OSCAR_ORDER_COMPLETE_STATUS': u'完成訂單',
                'OSCAR_ORDER_ARRIVE_STATUS': u'商品已到貨',
                'OSCAR_ORDER_STATUS_PIPELINE': {
                    u'等待處理中': \
                        (u'商品送貨中', u'訂單取消', u'測試用訂單'),
                    u'商品送貨中': \
                        (u'完成訂單', u'商品已到貨', 
                         u'訂單取消', u'測試用訂單'),
                    u'商品已到貨': (u'完成訂單', u'訂單取消', u'測試用訂單',),
                    u'訂單取消': (u'測試用訂單', ),
                    u'完成訂單': (u'測試用訂單', ),

                    u'商品退貨中': (u'完成退貨', u'測試用訂單'),
                    u'完成退貨': (u'測試用訂單',),
                    u'測試用訂單': (u'等待處理中',),
                }
            }
        else:
            ADDING_OSCAR_ORDER_STATUS = {
                'OSCAR_INITIAL_ORDER_STATUS': u'完成訂單',
                'OSCAR_INITIAL_LINE_STATUS': '-',
                'OSCAR_ORDER_STATUS_PIPELINE': {
                    u'完成訂單': (u'測試用訂單', ),
                    u'測試用訂單': (u'完成訂單',),
                }
            }

        update(settingsDict, ADDING_OSCAR_ORDER_STATUS)
    else:
        # check settings:
        unsettings = [s for s in allSettings if not s in settingsDict]
        if unsettings:
            raise KeyError("You should also set '%s' value." % str(unsettings))
    
    #=========================================================================

    

def attachShopURLs(settings, urlpatterns):
    """
    Attach shop related urlpatterns.
    It must be called in urls.py by passing urlpatterns.
 
    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """
    from Iuno.shop import views

    from django.conf.urls import url, patterns, include
    from django.contrib.admin.views.decorators import staff_member_required
    from oscar.app import application as shop
    from paypal.express.dashboard.app import application
    
    urlpatterns += patterns('',
        # the i18n is the default url settings of django oscar, but generally
        # we are not used.
        (r'^i18n/', include('django.conf.urls.i18n')),
        (r'^shop/', shop.urls),
    )

    paypalEnable = False
    if hasattr(settings, 'IUNO_SHOP_PAYPAL_ENABLE'):
        paypalEnable = settings.IUNO_SHOP_PAYPAL_ENABLE
    
    ecpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ECPAY_ENABLE'):
        ecpayEnable = settings.IUNO_SHOP_ECPAY_ENABLE

    allpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ALLPAY_ENABLE'):
        allpayEnable = settings.IUNO_SHOP_ALLPAY_ENABLE

    spgatewayEnable = False
    if hasattr(settings, 'IUNO_SHOP_SPGATEWAY_ENABLE'):
        spgatewayEnable = settings.IUNO_SHOP_SPGATEWAY_ENABLE

    cathaybkEnable = False
    if hasattr(settings, 'IUNO_SHOP_CATHAYBK_ENABLE'):
        cathaybkEnable = settings.IUNO_SHOP_CATHAYBK_ENABLE

    if paypalEnable:
        urlpatterns += patterns('',          
            url(r'^shop/dashboard/paypal/express/', application.urls),
            url(r'^checkout/paypal/place-order/(?P<basket_id>\d+)/$',
                views.SuccessResponseView.as_view(), name='paypal-place-order'),
            url(r'^checkout/paypal/', include('paypal.express.urls')),
        )

    if cathaybkEnable:
        urlpatterns += patterns('',
            url(r'^cathaybk-credit/checkxml/', views.returnCathaybkCreditXml),
        )

    if ecpayEnable or allpayEnable or spgatewayEnable:
        urlpatterns += patterns('',
            url(r'^(?P<name>.*)/preview/', 
                views.SuccessResponseView2.as_view()),
        )
    if ecpayEnable:
        urlpatterns += patterns('',
            url(r'^dashboard/ecpay/transaction/', 
                staff_member_required(
                    views.ECPayTransactionListView.as_view()),
                name='ecpayTransaction'),
            url(r'^dashboard/ecpaylogistic/transaction/', 
                staff_member_required(
                    views.ECPayLogisticTransactionListView.as_view()),
                name='ecpayLogisticTransaction'),
            url(r'^shop/ecpaylogistic/reply/', 
                views.ECPayServerReplyView.as_view(),
                name='ecpayLogisticReply'),
            url(r'^shop/ecpaylogistic/(?P<orderNumber>[\w-]*)/return/', 
                views.ECPayLogisticreturnView.as_view(),
                name='ecpayLogisticReturn'),
        )
    if allpayEnable:
        urlpatterns += patterns('',
            url(r'^dashboard/allpay/transaction/', 
                staff_member_required(
                    views.AllPayTransactionListView.as_view()),
                name='allpayTransaction'),
        )
    if spgatewayEnable:
        urlpatterns += patterns('',
            url(r'^dashboard/spgateway/transaction/', 
                staff_member_required(
                    views.SpgatewayTransactionListView.as_view()),
                name='spgatewayTransaction'),
        )

    if cathaybkEnable:
        urlpatterns += patterns('',
            url(r'^dashboard/spgateway/transaction/', 
                staff_member_required(
                    views.CathaybkCreditTransactionListView.as_view()),
                name='cathaybkCreditTransaction'),
        )

# ------------------------------------------------------------------------------
import hashlib
import time
import datetime

from django.conf import settings
from django.template.loader import get_template
from django.template import Context
from django.utils.translation import ugettext_lazy as _
from pyallpay import AllPay

from Iuppiter.Encoding import utf8
from Iuno.shop.Util import Pay2GoMPGAPI, CathaybkAPI

ECPAY_SANDBOX_SERVICE_URL = \
                    'https://payment-stage.ecpay.com.tw/Cashier/AioCheckOut/V2'
ECPAY_SERVICE_URL = 'https://payment.ecpay.com.tw/Cashier/AioCheckOut/V2'

ALLPAY_SANDBOX_SERVICE_URL = \
                    'http://payment-stage.allpay.com.tw/Cashier/AioCheckOut'
ALLPAY_SERVICE_URL = 'https://payment.allpay.com.tw/Cashier/AioCheckOut'

SPGATEWAY = 'spgateway'
ALLPAY = 'allpay'
ECPAY = 'ecpay'
ECPAY_MAP = 'ecpay_map'
ECPAY_LOGISTIC = 'ecpay_logistic'
CATHAYBK = 'cathaybk'

class AllPay2(AllPay):
    def gen_check_out_form(self, dict_url, auto_send=True):
        """
        Generate The Form Submission
        :param dict_url:
        :return: the html of the form
        """
        form_html = utf8(
            ('<form id="allPay-Form" name="allPayForm" method="post" '
             'target="_self" action="%s" style="display: none;">') % 
             self.service_url)

        for i, val in enumerate(dict_url):
            form_html += utf8(
                "<input type='hidden' name='%s' value='%s' />" % (
                    val, dict_url[val]))

        form_html  += utf8(
            '<input type="submit" class="large" '
            'id="payment-btn" value="BUY" /></form>')
        if auto_send:
            form_html += utf8("<script>document.allPayForm.submit();</script>")
        return form_html

def buildAPIForm(submission, request, apiName, extra={}):
    scheme = request.scheme
    domain = request.META['HTTP_HOST']

    if not apiName in [SPGATEWAY, ALLPAY, ECPAY, 
                       CATHAYBK, ECPAY_LOGISTIC, ECPAY_MAP]:
        raise ValueError("Not pay api name: %s" % apiName)

    MERCHANT_TRADE_NO_LEN = 20

    total = submission['order_total'].excl_tax
    basket = submission['basket']
    
    from django.conf import settings
    
    # item name
    itemName = utf8('')
    for index, line in enumerate(basket.all_lines()):
        product = line.product
        
        productName = product.get_title()
        itemName += utf8(productName)
        
        itemName += utf8(_(' %(dollar)d dollar X %(number)d#') % {
                    'dollar': line.price_excl_tax, 'number': line.quantity})
    itemName += utf8(_("shipping charge %(dollar)d dollar X 1") % {
                     'dollar': submission['shipping_charge'].excl_tax})

    itemName = utf8(itemName)
    
    # merchantTradeNo
    basketId = basket.id
    tradeNo = 'BASKETID%d' % basketId
    hashCode = hashlib.sha224(str(datetime.datetime.now())).hexdigest().upper()
    lenNo = (MERCHANT_TRADE_NO_LEN - len(tradeNo))
    merchantTradeNo = str(hashCode[0:lenNo]) + tradeNo
    

    # return url
    RETURN_URL = 'http://localhost:8000/%s/preview/' % apiName
    CLIENT_BACK_URL = 'http://localhost:8000/'
    PAYMENT_INFO_URL = 'http://localhost:8000/feedback'

    returnUrl = RETURN_URL.replace(
                           'localhost:8000', domain).replace('http', scheme)
    backUrl = CLIENT_BACK_URL.replace(
                        'localhost:8000', domain).replace('http', scheme)

    # build form data
    if apiName == SPGATEWAY:
        data = {
            'TimeStamp': time.time(),
            'RespondType': 'JSON',
            'Version': '1.2',
            'LangType': 'zh-tw',
            'MerchantID': settings.SPGATEWAY_API_MERCHANT_ID,
            'MerchantOrderNo': merchantTradeNo,
            'Amt': int(total),
            'ItemDesc': itemName.replace('#', '|'),
            'LoginType': 0,
            'CREDIT': 1,
            #'UNIONPAY': 1,
        }

        mpg = Pay2GoMPGAPI(
            hashKey=settings.SPGATEWAY_API_HASH_KEY,
            hashIv=settings.SPGATEWAY_API_HASH_IV,
            sandbox=settings.SPGATEWAY_SANDBOX_MODE,
        )

        payment = mpg.createPayment(data)
        context = Context({'spgateway': payment,})

        temp = get_template('shop/payment/Spgateway.html')
        form = temp.render(context)
                                      
        return form

    if apiName in [ECPAY, ALLPAY]:
        data = {
            'TotalAmount': int(total), 
            'ChoosePayment': 'Credit', 
            'MerchantTradeNo': merchantTradeNo, 
            'ItemName': itemName,
            'TradeDesc' : settings.OSCAR_SHOP_NAME, 
            'Remark' : settings.OSCAR_SHOP_NAME,
        }

        ap = AllPay2(data)

        if apiName == ECPAY:
            if settings.ECPAY_SANDBOX_MODE:
                ap.service_url = ECPAY_SANDBOX_SERVICE_URL
            else:
                ap.service_url = ECPAY_SERVICE_URL

            ap.url_dict['MerchantID'] = settings.ECPAY_API_MERCHANT_ID
            ap.HASH_KEY = settings.ECPAY_API_HASH_KEY
            ap.HASH_IV = settings.ECPAY_API_HASH_IV
        else:
            if settings.ALLPAY_SANDBOX_MODE:
                ap.service_url = ALLPAY_SANDBOX_SERVICE_URL
            else:
                ap.service_url = ALLPAY_SERVICE_URL

            ap.url_dict['MerchantID'] = settings.ALLPAY_API_MERCHANT_ID
            ap.HASH_KEY = settings.ALLPAY_API_HASH_KEY
            ap.HASH_IV = settings.ALLPAY_API_HASH_IV


        # modify return Url
        ap.url_dict['ReturnURL'] = returnUrl
        ap.url_dict['OrderResultURL'] = returnUrl
        ap.url_dict['ClientBackURL'] = backUrl

        dictUrl = ap.check_out()

        if apiName == ECPAY:
            form = ap.gen_check_out_form(dictUrl, 
                                    settings.ECPAY_AUTO_SEND_FORM)
            form = form.replace('allPay-Form', 'ecpayForm')
            form = form.replace('allPayForm', 'ecpayForm')
        else:
            form = ap.gen_check_out_form(dictUrl, 
                                    settings.ALLPAY_AUTO_SEND_FORM)
            form = form.replace('allPay-Form', 'allpayForm')
            form = form.replace('allPayForm', 'allpayForm')
        
        return form

    if apiName == CATHAYBK:
        mpg = CathaybkAPI(
            merchantId=settings.CATHAYBK_API_MERCHANT_ID,
            cubkey=settings.CATHAYBK_API_CUBKEY,
        )

        data = {
            'ORDERNUMBER': merchantTradeNo,
            'AMOUNT': int(total),
        }

        form = mpg.buildForm(data)
                                      
        return form

    if apiName == ECPAY_MAP:
        temp = get_template('shop/payment/EcpayMap.html')

        if settings.ECPAY_SANDBOX_MODE:
            apiUrl = "https://logistics-stage.ecpay.com.tw/Express/map"
        else:
            apiUrl = "https://logistics.ecpay.com.tw/Express/map"

        if hasattr(settings, "ECPAY_API_LOGISTIC_SUB_TYPES"):
            subTypes = settings.ECPAY_API_LOGISTIC_SUB_TYPES
        else:
            subTypes = {
                "FAMI": u"全家便利商店",
                "UNIMART": u"統一7-11超商" ,
                "HILIFE": u"萊爾富",
            }

        data = {
            'TradeDesc' : settings.OSCAR_SHOP_NAME, 
            'Remark' : settings.OSCAR_SHOP_NAME,
        }

        if submission['shipping_address']:
            needExtraData = False
        else:
            needExtraData = True

        context = Context({
            'apiUrl': apiUrl,
            'chantID': settings.ECPAY_API_MERCHANT_ID,
            'subTypes': subTypes,
            'returnUrl': returnUrl,
            'needExtraData': needExtraData,
            'extraData': json.dumps(
                data, ensure_ascii=False, default=str).replace("\"", "&quot;"),
        })
        form = temp.render(context)
                                      
        return form

    if apiName == ECPAY_LOGISTIC and request.session.get('logisticMap'):
        mapData = json.loads(request.session['logisticMap'])
        
        if settings.ECPAY_SANDBOX_MODE:
            apiUrl = "https://logistics-stage.ecpay.com.tw/Express/Create"
        else:
            apiUrl = "https://logistics.ecpay.com.tw/Express/Create"

        if hasattr(settings, "OSCAR_SHOP_NAME_FOR_ECPAY"):
            shopName = settings.OSCAR_SHOP_NAME_FOR_ECPAY
        else:
            shopName = settings.OSCAR_SHOP_NAME

        if hasattr(settings, "OSCAR_SHOP_PHONE"):
            shopPhone = settings.OSCAR_SHOP_PHONE 
        else:
            shopPhone = ''

        if "isCollection" in extra:
            isCollection = extra["isCollection"]
        else:
            isCollection = "Y"

        data = {
            "MerchantID": settings.ECPAY_API_MERCHANT_ID,
            "MerchantTradeNo": merchantTradeNo,
            "MerchantTradeDate": datetime.datetime.now().strftime(
                                    "%Y/%m/%d %H:%M:%S"),

            "LogisticsType": "CVS",
            "LogisticsSubType": mapData['storeType'],
            "IsCollection": isCollection,
            "ReceiverStoreID": mapData['storeId'],
            
            "GoodsAmount": int(total),
            "CollectionAmount": int(total),
            "GoodsName": itemName.replace(
                "#", ' ').replace("(", '').replace(")", '').decode('utf8'),
            
            # 必須 len(SendName) <= 10 個字元 
            "SenderName": shopName,
            "SenderCellPhone": shopPhone,

            "ReceiverName": mapData['receiverName'], 
            "ReceiverCellPhone": mapData['receiverPhone'], 
            
            # 隨時接訂單資訊的 URL
            "ServerReplyURL": backUrl[:-1] + reverse("ecpayLogisticReply"), 
            "ClientReplyURL": returnUrl, 
        }
        
        if mapData['storeType'] == "UNIMARTC2C":
            data["LogisticsC2CReplyURL"] = returnUrl
        
        data = OrderedDict(data)
        data = OrderedDict(sorted(data.iteritems()))

        orderedDict = OrderedDict()
        orderedDict['HashKey'] = settings.ECPAY_API_HASH_KEY
        for field in data:
            orderedDict[field] = data[field]

        orderedDict['HashIV'] = settings.ECPAY_API_HASH_IV

        dataList = []
        for k, v in orderedDict.items():
            dataList.append("%s=%s" % (k, v))
        dataStr = u"&".join(dataList)

        encodeStr = urllib.urlencode({'data': utf8(dataStr),})[5:]
        checkValue = hashlib.md5(encodeStr.lower()).hexdigest().upper()
        data["CheckMacValue"] = checkValue

        temp = get_template('shop/payment/EcpayLogistic.html')
        context = Context({
            'apiUrl': apiUrl,
            'data': data,
        })
        form = temp.render(context)

        return form
    return None