#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: BrowserPanel.py 9621 2016-04-06 13:36:10Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-06 21:36:10 +0800 (週三, 06 四月 2016) $
# $Revision: 9621 $

class BrowserPanel(object):
    """
    Browser panel factory.
    """

    @staticmethod
    def create(_browser=None, **kws):
        """
        Factory method to create BrowserPanel implementation instance.

        @param _browser 'trident' or 'webkit'.
        @param **kws Keyword arguments to pass to implementation instance
                     constructor.
        @return BrowserPanel instance.
        """
        from Iuno.browser import factory
        
        clazz = factory('BrowserPanel', _browser)
        return clazz(**kws)
