#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9627 2016-04-10 14:55:05Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-10 22:55:05 +0800 (週日, 10 四月 2016) $
# $Revision: 9627 $
"""
Celery tasks which should be run at cloud worker.
"""

import inspect
import logging

from celery.task import task

from Iuno.browser import tasks

logger = logging.getLogger(__name__)

# Register all tasks.
for name, value in inspect.getmembers(tasks):
    if inspect.isfunction(value) and value.__module__ == tasks.__name__:
        locals()[name] = task(queue='browser')(value)
