#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10389 2017-10-22 05:43:34Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-10-22 13:43:34 +0800 (週日, 22 十月 2017) $
# $Revision: 10389 $

from django.db import models
from jsonfield import JSONField

class Email(models.Model):
    email = models.EmailField()
    fromUrl = models.URLField()
    date = models.DateTimeField(
        auto_now_add=True)

    data = JSONField(null=True, blank=True, default={})
        
    def __unicode__(self):
        return u"%s From: %s (%s)" % (self.email, self.fromUrl, self.date)
