#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11731 2019-10-02 16:41:15Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-10-03 01:41:15 +0900 (週四, 03 十月 2019) $
# $Revision: 11731 $
#
# Contributors:
#  Bear (original author)
#  Yachu

from Iuno.Util import update

from Iuppiter.DjangoUtil import (
    extendInstalledApps, extendMiddlewareClasses)

def attachSettings(settingsLocals, backends, preferred, config):
    """
    Attach 'mail' related settings to settings.py.

    @param settingsLocals locals() in settings.py.
    @param backends Backend instances.
    @param preferred Preferred backends.
    @param config Configuration settings.
    """
    extendInstalledApps(settingsLocals, (
        'django_statsd',
        'Iuno.cloud.metrics',
    ))
    
    extendMiddlewareClasses(settingsLocals, [
        'django_statsd.middleware.StatsdMiddleware',
        ], 
        key='django.contrib.sessions.middleware.SessionMiddleware', 
        addBefore=True
    )
    
    extendMiddlewareClasses(settingsLocals, [
        'django_statsd.middleware.StatsdMiddlewareTimer',
    ])
    
    DEFAULT_STATSD_SETTINGS = {
        'STATSD_HOST': config.get("host", "statsd.nuwainfo.com"),
        "STATSD_PORT": config.get("post", 8125),
    }
    
    update(settingsLocals, DEFAULT_STATSD_SETTINGS)

