#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_templates.py 9976 2017-05-16 06:31:28Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-16 14:31:28 +0800 (週二, 16 五月 2017) $
# $Revision: 9976 $

import os
import sys
import logging

from django.core.management.base import BaseCommand, CommandError

from Zephyrus.boilerplate.management.commands import TEMPLATES_DIR_PATH

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

class Command(BaseCommand):

    help = 'Start build all template to dst folder.'
    args = '<start folder> <destination folder>'

    def handle(self, *args, **options):
        if len(args) < 2:
            raise CommandError(
                "You must specify a folder to get template."
                )

        startPath = args[0]
        dstPath = args[1]

        for f in os.listdir(startPath):
            tempPath = os.path.join(startPath, f)

            # get_template
            error = os.system(
                "%s manage.py get_template %s" % (sys.executable,  tempPath))
            if not error == 0:
                logger.error(
                    "get_template error code: %d, from template: %s" % 
                    (error, tempPath))
                continue

            # build_boilerplate
            error = os.system(
                "%s manage.py build_boilerplate %s" % 
                (sys.executable, TEMPLATES_DIR_PATH))
            if not error == 0:
                logger.error(
                    "build_boilerplate error code: %d, from template: %s" % 
                    (error, tempPath))
                continue

            # dumpdata
            error = os.system(
                ("%s manage.py dumpdata cms djangocms_text_ckeditor "
                 "cmsplugin_filer_image > fixtures/initial_data.json") % 
                 (sys.executable,))
            if not error == 0:
                logger.error(
                    "dumpdata error code: %d, from template: %s" % 
                    (error, tempPath))
                continue

            # create_zip
            error = os.system(
                "%s manage.py create_zip %s" % (sys.executable, dstPath))
            if not error == 0:
                logger.error(
                    "create_zip error code: %d, from template: %s" % 
                    (error, tempPath))
                continue