#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9754 2017-02-18 05:34:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-02-18 13:34:31 +0800 (?g??, 18 ?G?? 2017) $
# $Revision: 9754 $

from django import template

from Zephyrus.blog_extension.models import ViewCount as ViewCountModel

register = template.Library()

# FIXME: 不知為何使用 {% allCategoryRoots categories %} 會在畫面上 render 出字來，
# 先暫時 return 空字串避免畫面 render 出不必要的字，然後使用 context 回傳值
@register.simple_tag(takes_context=True)
def allCategoryRoots(context, categories):
    roots = []
    parents = []
    for category in categories:
        root = category.get_root()
        if not root in roots:
            roots.append(root)
            
        parent = category
        while parent:
            if not parent in parents:
                parents.append(parent)
            parent = parent.get_parent()
    context['roots'] = roots
    context['parents'] = parents
    return ''

@register.simple_tag(takes_context=True)
def viewCount(context, url=None):
    request = context['request']
    if url:
        if not url.startswith('http'): 
            url = request.build_absolute_uri('/')[:-1].strip("/") + url
        
        obj, created = ViewCountModel.objects.get_or_create(
            url=url,
        )
    else:
        url = request.build_absolute_uri(request.path)
        obj, created = ViewCountModel.objects.get_or_create(
            url=url,
        )
        obj.count += 1
        obj.save()
    
    return obj.count
    