#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import os
import json
import logging

from django.conf import settings
from django.core.management import call_command

from cms.models.pagemodel import Page

logger = logging.getLogger(__name__)

def configure():
    # Load fixtures if needed.
    pages = Page.objects.exists()
    _SERVER_MODE = settings.SERVER_MODE
    
    initialData = hasattr(settings, 'ZEPHYRUS_CMS_INITIAL_DATA')
    
    if not initialData:
        return
    initialData = settings.ZEPHYRUS_CMS_INITIAL_DATA

    logger.info('Check if need to load data...')
    if _SERVER_MODE == settings.DEVELOPMENT:
        if not pages:
            logger.info("Loading %s" % initialData)
            call_command('cms_loaddata', initialData)
    else:
        if not pages:
            logger.info('Open original data...')
                
            with open(initialData, "r") as jsonFile:
                data = json.load(jsonFile)

            logger.info('Editing original data...')
            for ele in data:
                if 'site' in ele['fields']:
                    if ele['fields']['site']:
                        ele['fields']['site'] = _SERVER_MODE
            
            logger.info('Dump edited cms data...')
            updatedCmsDataPath = os.path.join(
                'initial_data_%s.json' % (_SERVER_MODE, )
            )

            with open(updatedCmsDataPath, 'w') as outfile:
                json.dump(data, outfile)
            
            logger.info("Loading initial cms data...")
            call_command(
                'cms_loaddata', 
                'initial_data_%s.json' % (_SERVER_MODE, ))
            logger.info('Load cms data success.')
        else:
            logger.info('No need to load cms data')