#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: scaffold.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import sys
import datetime
import hashlib
import requests

from django.conf import settings
from django.core.management.base import BaseCommand

from Iuno.shop.models import ECPayLogisticTrade
from Iuno import DEVELOPMENT, STAGE, PRODUCTION


class Command(BaseCommand):
    
    help = 'Simulate ecpay logistic post to change order status.'
    
    def add_arguments(self, parser):
        parser.add_argument('tradeNo', type=str, help="Ecpay tradeNo.")
        parser.add_argument('code', type=int, help="Ecpay status code.")
    
    def handle(self, app='', *args, **options):
        if settings.SERVER_MODE == DEVELOPMENT:
            tradeNo = options['tradeNo']
            code = options['code']

            logisticTrade = ECPayLogisticTrade.objects.filter(
                tradeNo=tradeNo).order_by('-id').first()

            subType = logisticTrade.logisticsSubType
            codeTable = {
                3024: u"商品已送至物流中心",
                3018: u"商品已送達門市",
                3022: u"消費者成功取件",
                3020: u"消費者七天未取件",

                2030: u"商品已送至物流中心",
                2063: u"商品已送達門市",
                2067: u"消費者成功取件",
                2070: u"消費者七天未取件",
            }

            data = {
                'ReceiverName': logisticTrade.receiverName,
                'ReceiverEmail': logisticTrade.receiverEmail,
                'ReceiverCellPhone': logisticTrade.receiverCellPhone,
                'LogisticsType': logisticTrade.logisticsType,
                'LogisticsSubType': logisticTrade.logisticsSubType,
                'UpdateStatusDate': str(datetime.datetime.now()),
                'ReceiverPhone': '',
                'RtnCode': code,
                'BookingNote': '',
                'CVSValidationNo': '',
                'ReceiverAddress': '',
                'MerchantTradeNo': logisticTrade.merchantTradeNo,
                'CVSPaymentNo': '',
                'MerchantID': logisticTrade.merchantId,
                'RtnMsg': codeTable[code],
                'GoodsAmount': logisticTrade.tradeAmt,
                'AllPayLogisticsID': logisticTrade.tradeNo,
            }

            r = requests.post(
                'http://127.0.0.1:8000/shop/ecpaylogistic/reply/', 
                data=data
            )

            print("Result: %s" % r.text)
        else:
            print("This command is only use in DEVELOPMENT mode.")
            sys.exit(1)