#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11641 2019-06-19 07:33:01Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-19 15:33:01 +0800 (週三, 19 六月 2019) $
# $Revision: 11641 $

import six
import urllib

from django.contrib import admin

from Iuppiter.Encoding import utf8

from Zephyrus.statistics import views
from Zephyrus.statistics.models import URL

@admin.register(URL)
class URLAdmin(admin.ModelAdmin):
    model = URL

    list_display = ['getUrl', 'viewCount', 'likeCount', 'commentCount']
    
    def getUrl(self, obj):
        if six.PY3:
            name = urllib.parse.unquote(str(obj.url))
        else:
            name = urllib.unquote(str(obj.url))
            
        name = utf8(name).decode('utf8')
         
        return u"<a target='_blank' href='%s'>%s</a>" % (obj.url, name)

    getUrl.short_description = "URL"
    getUrl.admin_order_field = 'url'
    getUrl.allow_tags = True
