#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Utility.py 10797 2018-03-01 02:31:02Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-01 10:31:02 +0800 (Thu, 01 Mar 2018) $
# $Revision: 10797 $

from django.conf.urls import url, include, patterns

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """

    # Theophrastus newsletter document url
    if 'Theophrastus.document' in settings.INSTALLED_APPS:
        urlpatterns += patterns('',
            url(r'^admin/', include('Theophrastus.document.urls')),
        )

    # Theophrastus newsletter urls
    urlpatterns += patterns('',
        url(r'^newsletters/', include('Theophrastus.urls')),
    )
    
    # Tinymic editor.
    if 'Theophrastus.editor' in settings.INSTALLED_APPS:
        urlpatterns += patterns('',
            url(r'^tinymce/', include('tinymce.urls')),
        )
    