#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 10803 2018-03-02 03:45:30Z David $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-02 11:45:30 +0800 (Fri, 02 Mar 2018) $
# $Revision: 10803 $

from django import forms
from django.contrib import admin
from django.utils.translation import gettext as _
from django.core.urlresolvers import reverse

from emencia.django.newsletter.models import Newsletter
# #FIXME: Django forms dependencies issues, 
# see https://code.nuwainfo.com/trac/mercurius/ticket/3022
# from emencia.django.newsletter.admin import NewsletterAdmin
from Theophrastus.newsletter_extension.admin import NewsletterExtensionAdmin \
                                                    as NewsletterAdmin
from Theophrastus.newsletter_extension.admin import NewsletterForm
from TinyMCEWidget import CustomTinyMCEWidget

class NewsletterTinyMCEForm(NewsletterForm):
    def __init__(self, *args, **kwargs):
        super(NewsletterTinyMCEForm, self).__init__(*args, **kwargs)

    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 150, 'rows': 80}),
        label=_("Content"))

class NewsletterTinyMCEAdmin(NewsletterAdmin):
    form = NewsletterTinyMCEForm

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterTinyMCEAdmin)

