from django import template
from django.template.loader import render_to_string
from django.contrib.sites.models import Site
from django.template import Context


from emencia.django.newsletter.models import Newsletter
from emencia.django.newsletter.utils.newsletter import body_insertion
from emencia.django.newsletter.utils.tokens import tokenize

from Theophrastus.newsletter_extension.views import getHeaderContent, \
                                                    getFooterContent

register = template.Library()

@register.simple_tag
def getCustomisedHeader(contact, newsletter):
    
    uidb36, token = tokenize(contact)
    context = Context({'contact': contact,
                    'domain': Site.objects.get_current().domain,
                    'newsletter': newsletter,
                    'uidb36': uidb36, 'token': token})
    headerContent = getHeaderContent(newsletter)

    linkSite = headerContent.render(context)
    
    return linkSite

@register.simple_tag
def getCustomisedFooter(contact, newsletter):
    
    uidb36, token = tokenize(contact)
    context = Context({'contact': contact,
                    'domain': Site.objects.get_current().domain,
                    'newsletter': newsletter,
                    'uidb36': uidb36, 'token': token})

    footerContent = getFooterContent(newsletter)
    
    unsubscription = footerContent.render(context)
    
    return unsubscription