/**
$Id: Newsletter.js 9579 2016-03-09 01:43:46Z Judy $

Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Judy $
$Date: 2016-03-09 09:43:46 +0800 (週三, 09 三月 2016) $
$Revision: 9579 $
*/

$().ready(function() {
    var $serverSelectBox = $('#id_server');
    /*
     * Show verification buttons if user select "Cloud SMTP Server".
     *
     * @param target MailServer combobox DOM object.
    */
    function toggleVerificationButtons(target) {
        if ($(target).val() == 1) { // Select Cloud SMTP Server.
            $('[name=cloudHelp]').show();
        }
        else {
            $('[name=cloudHelp]').hide();
        }
    };
    
    /*
     * Show loading DOM object if user click verification button.
     *
     * @param open MailServer combobox DOM object.
    */
    var toggleLoadingStatus = function(open) {
        var $submitRow = $('#newsletter_form .submit-row');
        if (open) { // Select Cloud SMTP Server.
            $submitRow.hide();
            $('#loadingDiv').show();
            $('[name=cloudHelp]').hide();
            $('#loadingP').show();
        }
        else {
            $submitRow.show();
            $('#loadingDiv').hide();
            $('[name=cloudHelp]').show();
            $('#loadingP').hide();
        }
    };
    
    var setNotificationTopic = function() {
        $.ajax({
            type: "GET",
            data: {email: $('#id_header_sender').val()},
            url: setNotificationTopicUrl,
            dataType: "jsonp",
            jsonp: "jsonpcallback",
            crossDomain: true,
            success: function (response) {
                if (!response.result) {
                    alert(response.message);
                    return false;
                }
            },
            error: function() {
                alert('很抱歉，設定Topic發生錯誤，請稍後再嘗試。');
            },
            complete: function() {
                toggleLoadingStatus(false);
            }
        });
    };
    
    function attachReplyUI() {
        var parent = $('#id_header_reply').parent();
        $(parent).append(
            '<p class="help">請輸入一個回復位址，例如： ' +
            '名稱&lt;電子郵件位址&gt;，名稱只可輸入英文字母、數字或符號。</p>');
    };
    
    function attachVerificationUI(sender) {
        var $sender = sender;
        var parent = $sender.parent();
        $(parent).append(
            '<p name="cloudHelp" class="help">請輸入一個收件人，例如： ' +
            '名稱&lt;電子郵件位址&gt;。 您的電子郵件位址需要驗證。</p>');
        $(parent).append(
            '<p name="cloudHelp" class="help">' +
            '<a id="verify" href="javascript:void(0);">驗證</a> | ' +
            '<a id="deleteVerification" href="javascript:void(0);">' + 
            '刪除驗證</a></p>');
        $(parent).append(
            '<p id="loadingP" class="help">' +
            '<img src="/static/images/base/Loading.gif" alt="loading" /></p>');
        $('#loadingP').hide();
        
        // Events.
        $serverSelectBox.change(function() {
            toggleVerificationButtons($(this));
        });
        
        $('#verify').click(function() {
            toggleLoadingStatus(true);
            $.ajax({
                type: "GET",
                data: {email: $sender.val()},
                url: verifyEmailAddressUrl,
                dataType: "jsonp",
                jsonp: "jsonpcallback",
                crossDomain: false,
                success: function (response) {
                    if (response.verification) {
                        if (response.continue) {
                            if (window.confirm(response.message)) {
                                setNotificationTopic();
                            }
                            else {
                                toggleLoadingStatus(false);
                            }
                        }
                        else {
                            alert(response.message);
                            setNotificationTopic();
                        }
                    }
                    else {
                        $sender.focus();
                        alert(response.message);
                        toggleLoadingStatus(false);
                    }
                },
                error: function() {
                    alert('很抱歉，您要求驗證發生錯誤，請稍後再嘗試。');
                    toggleLoadingStatus(false);
                }
            });
        });
    
        $('#deleteVerification').click(function() {
            toggleLoadingStatus(true);
            $.ajax({
                type: "GET",
                data: {email: $sender.val()},
                url: deleteVerifiedEmailAddressUrl,
                dataType: "jsonp",
                jsonp: "jsonpcallback",
                crossDomain: false,
                success: function (response) {
                    if (response.verification) {
                        alert(response.message);
                    }
                    else {
                        $sender.focus();
                        alert(response.message);
                    }
                },
                error: function() {
                    alert('很抱歉，您要求移除驗證發生錯誤，請稍後再嘗試。');
                },
                complete: function() {
                    toggleLoadingStatus(false);
                }
            });
        });
    };
    
    function modifyControlButtons() {
        var $sender = $('#id_header_sender');
        // Hide save button.
        $('#newsletter_form [type=submit]').hide();
        var $submitRow = $('#newsletter_form .submit-row');
    
        // Insert checking div.
        $('<div id="loadingDiv" class="submit-row">' + 
          '<img src="/static/images/base/Loading.gif" alt="loading" />' + 
          '檢查中...</div>').insertAfter($submitRow);
        $('#loadingDiv').hide();
 
        $submitRow.append(
            '<input type="button" id="check" class="default" value="儲存" />');
        $submitRow.append(
            '<input type="button" id="enforceSave" value="強制儲存" />');
        $submitRow.append(
            '<input type="button" id="continue" value="儲存並繼續編輯" />');
        $submitRow.append(
            '<input type="button" id="addAnother" value="儲存並增加另一個" />');

        // Events.
        var hasVerified = function(email, btnTarget) {
            $submitRow.hide();
            $('#loadingDiv').show();
            $.ajax({
                type: "GET",
                data: {email: email},
                url: checkVerifiedEmailAddressUrl,
                dataType: "jsonp",
                jsonp: "jsonpcallback",
                crossDomain: true,
                success: function (response) {
                    if (response.verification) {
                        checkStatus(btnTarget);
                    }
                    else {
                        $sender.focus();
                        alert(response.message);
                    }
                },
                error: function() {
                    alert('很抱歉，進行驗證時發生錯誤，請稍後再嘗試。');
                },
                complete: function() {
                    $('#loadingDiv').hide();
                    $submitRow.show();
                }
            });
        };
        
        var showFormMask = function() {
            if ($('#formMask').length <= 0) {
                var $form = $('#newsletter_form');
                var mask = '<div id="formMask" style="display:none;">' + 
                           '<span>Loading</span></div>';
                $(mask).insertBefore($form);
            }
            $('#formMask').show();
        };
        
        var hideFormMask = function() {
            $('#formMask').hide();
        };
        
        var checkStatus = function($btn) {
            var status = $('#id_status').val();
            if (status == '1') {
                // Show mask.
                showFormMask();
                $.ajax({
                    type: "GET",
                    data: {mailingList: $('#id_mailing_list').val()},
                    url: getMailingListInfoUrl,
                    dataType: "jsonp",
                    jsonp: "jsonpcallback",
                    crossDomain: true,
                    success: function (response) {
                        var message;
                        if (typeof(response) != 'undefined') {
                            var count = response.subscribersCount;
                            var name = response.name;
                            message = "即將開始寄送電子報，您的郵件列表為 '" + 
                                      name + "' ，寄送的聯絡人共有" + count +
                                      "位，您確定要執行嗎？";
                        }
                        else {
                            message = "即將開始寄送電子報，請再次檢查您的資料" + 
                                      "，您確定要執行嗎？";
                        }
                        if (window.confirm(message)) {
                            $btn.click();
                        }
                        else {
                            return false;
                        }
                    },
                    error: function() {
                        alert('即將開始寄送電子報，您確定要執行嗎？');
                    },
                    complete: function() {
                        // Hide mask.
                        hideFormMask();
                    }
                });
            }
            else {
                $btn.click();
            }
        };
        
        $('#check').click(function() {
            var $btn = $('#newsletter_form [name=_save]');
            if ($serverSelectBox.val() != '1') {
                checkStatus($btn);
            }
            else {
                hasVerified($sender.val(), $btn);
            }
        });
        
        $('#continue').click(function() {
            var $btn = $('#newsletter_form [name=_continue]');
            if ($serverSelectBox.val() != '1') {
                checkStatus($btn);
            }
            else {
                hasVerified($sender.val(), $btn);
            }
        });
        
        $('#addAnother').click(function() {
            var $btn = $('#newsletter_form [name=_addanother]');
            if ($serverSelectBox.val() != '1') {
                checkStatus($btn);
            }
            else {
                hasVerified($sender.val(), $btn);
            }
        });
        
        $('#enforceSave').click(function() {
            var $btn = $('#newsletter_form [name=_save]');
            if ($serverSelectBox.val() != '1') {
                checkStatus($btn);
            }
            else {
                var answer = window.confirm(
                    '強制儲存無法確保您的寄信人是否驗證過，可能會造成' +
                    '無法寄出電子報的問題，您確定要繼續?');
                if (answer) {
                    checkStatus($btn);
                }
                else {
                    return false;
                }
            }
        });
    };
    
    /*
     * Modify user interface.
    */
    function modifyUI() {
        var $sender = $('#id_header_sender');
        // Adjusted field size.
        $sender.attr('size', '60');
        $('#id_header_reply').attr('size', '60');
        
        attachVerificationUI($sender);
        attachReplyUI();
        modifyControlButtons();
        
        // Auto generate slug.
        $('#id_title').blur(function() {
            var title = $.trim($(this).val());
            if (title != "") {
                $.getJSON(
                    getSlugNameUrl + '?title=' + title,
                    function(response) {
                        $('#id_slug').val(response.slug);
                    }
                );
            }
        });
        
    };
    
    // Initial.
    modifyUI();
    toggleVerificationButtons($serverSelectBox);
});
