# Generated by Django 2.2.12 on 2021-03-25 07:03

from django.db import migrations, models
import django.utils.timezone

def moveContactEmailToEmailField(apps, schema_editor):
    BlackContact = apps.get_model('newsletter_extension', 'BlackContact')
    for bc in BlackContact.objects.all():
        bc.email = bc.contact.email
        bc.save()


class Migration(migrations.Migration):

    dependencies = [
        ('newsletter_extension', '0007_auto_20210318_1419'),
    ]

    operations = [
        migrations.AddField(
            model_name='blackcontact',
            name='createdTime',
            field=models.DateTimeField(default=django.utils.timezone.now, verbose_name='Created time'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='blackcontact',
            name='email',
            field=models.EmailField(null=True, default=None, max_length=254, verbose_name='Email'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='blackcontact',
            name='reason',
            field=models.TextField(verbose_name='Reason'),
        ),
        
        migrations.RunPython(moveContactEmailToEmailField),
        
        migrations.RemoveField(
            model_name='blackcontact',
            name='contact',
        ),
        migrations.AlterField(
            model_name='blackcontact',
            name='email',
            field=models.EmailField(db_index=True, max_length=254, verbose_name='Email'),
        ),
    ]
