#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 12803 2021-03-18 07:29:01Z Lavender $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-03-18 15:29:01 +0800 (Thu, 18 Mar 2021) $
# $Revision: 12803 $

from django.conf.urls import url

from Theophrastus.newsletter_extension import views

urlpatterns = [
    url(r'^newsletter/header/text/$', views.getDefaultHeaderText,
        name='Theophrastus.newsletter_extension.views.getDefaultHeaderText'),
    url(r'^newsletter/footer/text/$', views.getDefaultFooterText,
        name='Theophrastus.newsletter_extension.views.getDefaultFooterText'),
    url(r'^slug/get/$', views.getSlugName,
        name="Theophrastus.newsletter_extension.views.getSlugName"),
    url(r'^mailingList/get/$', views.getMailingListInfo,
        name="Theophrastus.newsletter_extension.views.getMailingListInfo"),
        
    # black contact
    url(r'^blackcontact/search/$', views.BlackContactSearchView.as_view()),
    url(r'^blackcontact/add/$', views.BlackContactAddView.as_view()),
]

