#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11006 2018-05-01 07:48:58Z Kevin $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $
# $Date: 2018-05-01 15:48:58 +0800 (Tue, 01 May 2018) $
# $Revision: 11006 $

from django.db.models import Q, Max as modelsMax
from django.contrib.admin.views.decorators import staff_member_required
from django.http import Http404

from Iuppiter.extension.views import view, jsonpCallback

from emencia.django.newsletter.models import ContactMailingStatus, Newsletter

from Theophrastus.statistics.StatisticsHandler import getStartDateEndDate
from Theophrastus.statistics.StatisticsHandler import getStatisticsTotalData
from Theophrastus.statistics.StatisticsHandler import getStatisticsTotalRateData
from Theophrastus.statistics.StatisticsHandler import getSubscriberHistory

def getNewsletterOr404(slug):
    try:
        return Newsletter.objects.get(slug=slug)
    except:
        raise Http404

@jsonpCallback()
def getTotalData(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = getNewsletterOr404(slug)

    subscriberCount = newsletter.mailing_list.subscribers_count()
    testSubscriberCount = newsletter.mailing_list.subscribers.filter(
        tester=True).count()

    conditions = {'newsletter': newsletter}
    response = getStatisticsTotalData(request.GET, subscriberCount, 
                                      testSubscriberCount, conditions)
    return response

@jsonpCallback()
def getTotalRateData(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = getNewsletterOr404(slug)

    subscriberCount = newsletter.mailing_list.subscribers_count()
    testSubscriberCount = newsletter.mailing_list.subscribers.filter(
        tester=True).count()

    conditions = {'newsletter': newsletter}
    response = getStatisticsTotalRateData(
        request.GET, subscriberCount, testSubscriberCount, conditions)
    return response

@jsonpCallback()
def getHistory(request, slug):
    """
    Get history data of subscribers.

    @param slug Slug.
    """
    newsletter = getNewsletterOr404(slug)
    condition = {'newsletter': newsletter}
    status = request.GET.get('status', '')
    if status:
        condition.update({'status': int(status)})

    keyword = request.GET.get('keyword', '')

    if keyword:
        condition.update({
            'QList': [
                Q(contact__first_name__icontains=keyword)
                | Q(contact__last_name__icontains=keyword)
                | Q(contact__email__icontains=keyword)
                | Q(contact__tags__icontains=keyword)
            ]
        })

    response = getSubscriberHistory(request.GET, condition)
    return response

@staff_member_required
@view('Statistics.html')
def displayStatistics(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = Newsletter.objects.get(slug=slug)
    startDate, endDate = getStartDateEndDate()
    return {'newsletter': newsletter, 
            'startDate' : startDate,
            'endDate' : endDate}

@staff_member_required
@view('Subscribers.html')
def displaySubscribers(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = Newsletter.objects.get(slug=slug)
    _status = dict(ContactMailingStatus.STATUS_CHOICES)
    return {
        'newsletter': newsletter,
        'statusNames': _status.values(),
        'statusCode': _status.keys(),
    }
