#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_zip.py 9878 2017-04-17 06:04:20Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-17 14:04:20 +0800 (週一, 17 四月 2017) $
# $Revision: 9878 $

import os
import logging
import shutil
import zipfile
import json
import hashlib

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

TEMPLATES_DIR_PATH = os.path.abspath(
    os.path.join('.', 'templates'))

STATIC_DIT_PATH = os.path.abspath(
    os.path.join('.', 'static'))

FIXTURES_DIT_PATH = os.path.abspath(
    os.path.join('.', 'fixtures'))

ROOT_DIR_PATH = os.path.abspath(
    os.path.join('.'))
    
IMAGES_DIT_PATH = os.path.abspath(
    os.path.join('.', 'images'))

class Command(BaseCommand):

    help = 'Create zip file to destination folder.'
    args = '<destination folder>'

    def handle(self, *args, **options):
        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to get template."
                )

        dst = args[0]

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

        content = ''
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for temp in files:
                with open(os.path.join(root, temp)) as f:
                    content += f.read()
        data['checksum'] = hashlib.md5(content).hexdigest()

        with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
            line = json.dumps(data)
            f.write(line)

        zip = zipfile.ZipFile(
            os.path.join(ROOT_DIR_PATH, 'template.zip'), mode='w')

        logger.info("-----Start copy templates-----")
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for file in files:
                path = 'templates/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
        for root, dirs, files in os.walk(STATIC_DIT_PATH):
            staticPath = root[root.index('static'):]
            for file in files:
                path = '%s/%s' % (staticPath, file)
                logger.info("Zip " + path)
                zip.write(path)
        for root, dirs, files in os.walk(FIXTURES_DIT_PATH):
            for file in files:
                path = 'fixtures/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
                
        temp = get_template('py/setup.py')
        content = temp.render()
        with open(os.path.join(ROOT_DIR_PATH, 'setup.py'), 'w') as f:
            f.write(content)

        zip.write('./README.txt')
        logger.info("Zip README.txt")
        zip.write('./setup.py')
        logger.info("Zip setup.py")

        zip.close()


        zip = zipfile.ZipFile(
            os.path.join(dst, '%s.zip' % data['upc']), mode='w')
        zip.write('info.json')
        
        for root, dirs, files in os.walk(IMAGES_DIT_PATH):
            for file in files:
                path = 'images/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
                
        zip.write('template.zip')
        zip.close()
        

        logger.info('-----All OK!-----')