#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: pluginize.py 9906 2017-04-23 15:13:49Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-23 23:13:49 +0800 (週日, 23 四月 2017) $
# $Revision: 9906 $

import os
import json
import logging
import shutil
import hashlib

from django.core.management.base import BaseCommand
from django.core.management import call_command
from django.test.client import RequestFactory
from django.db import transaction
from django.template.loader import get_template
from django.template import Context

from djangocms_text_ckeditor.cms_plugins import TextPlugin
from cms.templatetags.cms_tags import *
from filer.models.filemodels import File
from cms.models.pagemodel import Page
from lxml.html import fromstring

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

os.chdir('.')

ROOT_DIR_PATH = os.path.abspath(
    os.path.join('.'))
    
STATIC_DIT_PATH = os.path.abspath(
    os.path.join('.', 'static'))
    
TEMPLATES_DIR_PATH = os.path.abspath(
    os.path.join('.', 'templates'))

jsPath = os.path.join(STATIC_DIT_PATH, 'js', 'FixTemplate.js')

complexity = 0

imgList = []

class Attr(object):
    def __init__(self, name, value):
        self.name = name
        self.value = value 

class Img(object):
    def __init__(self, name, md5, attrList):
        self.name = name
        self.md5 = md5
        self.attrList = attrList

    def __eq__(self, other):
        if self.name == other.name:
            return True
        return False

class Placeholder2(Placeholder):

    lang = 'zh-hant'

    def render_tag(self, context, name, extra_bits, nodelist=None):

        super(Placeholder2, self).render_tag(context, name,
                                                       extra_bits, nodelist)
        content = nodelist.render(context)
        
        self.writeContent(name, content)
        return content

    def writeContent(self, name, content):
        # get placeholderId by name in cms_placeholder
        # if placeholderId has no plugin, add textPlugin to cms_plugin
        # query plugin id, then write content to django_text_ckeditor_text
        from django.db import models
        from cms.models.placeholdermodel import Placeholder
        from cms.models.pluginmodel import CMSPlugin
        from djangocms_text_ckeditor.models import Text
        from cmsplugin_filer_image.models import FilerImage

        placeholders = Placeholder.objects.filter(slot=name)

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

            if 'complexity' in data:
                data['complexity'] = data['complexity'] + len(placeholders)
            else:
                data['complexity'] = len(placeholders)

            with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                line = json.dumps(data)
                f.write(line)
        
        for placeholder in placeholders:
            logger.info("id: %s, name: %s" % (placeholder.id, placeholder.slot))
            hasTextPlugin = Text.objects.filter(
                                    placeholder=placeholder, position=0
                            ).exists()
            hasImgPlugin = FilerImage.objects.filter(
                                        placeholder=placeholder).exists()

            if not hasTextPlugin and not hasImgPlugin:
                
                if content.lower().strip().startswith('<img'):
                    img = fromstring(content)
                    
                    url = img.get('src')
                    if url is None:
                        continue

                    attrs = img.items()

                    if url.startswith("{% static \"") and url.endswith("\" %}"):
                        url = "/static/" + url[12:-4]

                    attrList = []
                    for k, v in attrs:
                        if k == 'src':
                            continue
                        attrList.append(Attr(k, v))
                    
                    
                    imgList.append(
                        Img(placeholder.slot, 
                        hashlib.md5(placeholder.slot).hexdigest(), attrList))
                    
                    """
                    code = 'img' + hashlib.md5(url).hexdigest()
                    slot = placeholder.slot
                    # filer_image 
                    with open(jsPath, 'a+') as f:
                        for k, v in attrs:
                            divIf = "if($j('#%s').val() == ''){\n" % (slot)
                            nextImg = "$j('#%s').next()" % (slot)
                            next3Img = "$j('#%s').next().next().next()" % (slot)
                            jsIf = ( 
                                "if(%s.attr('class').search('filer_image')"
                                " >= 0){\n") % nextImg
                            jsElseIf = (
                                "} else if (%s.attr('class').search("
                                "'filer_image') >= 0){\n") % next3Img
                            if k == 'class':
                                js = divIf + jsIf
                                js += (
                                    "var %s = %s.attr('class');\n"
                                    ) % (code, nextImg)
                                js += (
                                    "%s.attr('class', '%s ' + %s);\n"
                                    ) % (nextImg, v, code)
                                js += jsElseIf
                                js += (
                                    "var %s = %s.attr('class');\n"
                                    ) % (code, next3Img)
                                js += (
                                    "%s.attr('class', '%s ' + %s);\n"
                                    ) % (next3Img, v, code)
                                js += "}\n}\n"
                            elif k == 'id' or k == 'style':
                                js = divIf + jsIf
                                js = (
                                    "%s.attr('%s', '%s');\n") % (next3Img, k, v)
                                js += jsElseIf
                                js = (
                                    "%s.attr('%s', '%s');\n") % (next3Img, k, v)
                                js += "}\n}\n"
                            else:
                                continue
                            f.write(js + '\n')
                    """
                    
                    FilerImage.objects.create(placeholder=placeholder,
                                              language=Placeholder2.lang,
                                              caption_text='', image_url=url,
                                              plugin_type='FilerImagePlugin',)
                    
                else:
                
                    Text.objects.create(placeholder=placeholder,
                                        language=Placeholder2.lang,
                                        body=content, plugin_type='TextPlugin')


class Command(BaseCommand):
    
    help = 'Add TextPlugin to default placeholders which are without plugin.'
    args = '[language]'
    
    # Validation is called explicitly each time the server is reloaded.
    requires_model_validation = False
    
    def handle(self, language='', *args, **options):
        
        from django import template
        from django.core.urlresolvers import reverse
        from django.contrib.auth.models import AnonymousUser
        
        from sekizai.context import SekizaiContext
        
        from cms.templatetags.cms_tags import register
        
        if language:
            Placeholder2.lang = language
        
        register.tags['placeholder'] = Placeholder2
        #register.tag(Placeholder2)
        
        path = TEMPLATES_DIR_PATH
        logger.error('Processing...')

        if not os.path.exists(os.path.join(STATIC_DIT_PATH, 'js')):
            os.mkdir(os.path.join(STATIC_DIT_PATH, 'js'))
            
        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

            data['pages'] = len(os.listdir(path))

            with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                line = json.dumps(data)
                f.write(line)

        """
        with open(jsPath, 'w') as f:
            f.write("$j( document ).ready(function() {\n")
        """
        @transaction.atomic
        def process():
            for file in os.listdir(path):
                file = os.path.join(path, file)
                logger.info(file)
                f = open(file)
                t = template.Template(f.read())
                c = SekizaiContext()
                factory = RequestFactory()
                c['request'] = factory.get('/' + Placeholder2.lang + '/')
                c['request'].user = AnonymousUser()
                c['request'].current_page = Page.objects.get(pk=1)
                t.render(c)

        process()
        """
        divClass = 'div' + hashlib.md5(' __tmp__img__div').hexdigest()
        with open(jsPath, 'a+') as f:
            f.write("$j('.%s').remove();\n" % divClass)
            f.write("});")
        """
        # Unique List obj
        newImgList = []
        for img in imgList:
            if not img in newImgList:
                newImgList.append(img)
        temp = get_template('js/FixTemplate.js')
        replaceStr = Context({
            'imgList': newImgList, 
        })
        content = temp.render(replaceStr)
        with open(jsPath, 'w') as f:
            f.write(content)

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)
        
        logger.info('Complexity : %d' % data['complexity'])
        logger.info('UPC : %s' % data['upc'])
        
        logger.info('DONE!')
        

        
                        