# -*- coding: utf-8 -*-
# Generated by Django 1.11.13 on 2019-10-29 07:36
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

def setOdererAddress(apps, schemaEditor):
    OrdererAddress = apps.get_model('shop', 'OrdererAddress')
    UserAddress = apps.get_model('address', 'UserAddress')
    for address in UserAddress.objects.all().order_by('-id'):
        ordererAddress, created = OrdererAddress.objects.get_or_create(
            user=address.user,
            defaults={
                'address': address,
            }
        )
        ordererAddress.address = address
        ordererAddress.save()

class Migration(migrations.Migration):

    dependencies = [
        ('address', '0006_auto_20181115_1953'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('shop', '0008_auto_20191022_1633'),
    ]

    operations = [
        migrations.CreateModel(
            name='OrdererAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ordererAddress', to='address.UserAddress', verbose_name='Orderer Address')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='orderer', to=settings.AUTH_USER_MODEL, verbose_name='Orderer')),
            ],
        ),
        migrations.RunPython(setOdererAddress),
    ]
