#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_tree.py 11930 2020-02-18 16:03:26Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-02-19 00:03:26 +0800 (Wed, 19 Feb 2020) $
# $Revision: 11930 $

import os

from django.conf import settings
from django.db import transaction
from django.core.management.base import BaseCommand

from Iuno.template_editor.models import Static, Template, FOLDER, FILE
from Iuno.template_editor.admin import checkVersion
from Iuno.template_editor import TEMPLATE_DIR, STATIC_DIR, BACKUP_FILE_DIR

class Command(BaseCommand):

    def handle(self, *args, **options):
        print("Delete all nodes...")
        Static.objects.all().delete()
        Template.objects.all().delete()

        self.staticPath = STATIC_DIR
        self.templatePath = TEMPLATE_DIR

        self.staticDirs = None
        if hasattr(settings, 'TEMPLATE_EDITOR_PUBLIC_STATIC'):
            self.staticDirs = settings.TEMPLATE_EDITOR_PUBLIC_STATIC
        else:
            self.staticDirs = [
                os.path.join(self.staticPath, 'js'),
                os.path.join(self.staticPath, 'images'),
                os.path.join(self.staticPath, 'css'),
            ]
        
        self.templateDirs = None
        if hasattr(settings, 'TEMPLATE_EDITOR_PUBLIC_TEMPLATES'):
            self.templateDirs = settings.TEMPLATE_EDITOR_PUBLIC_TEMPLATES

        self.createNode(self.staticPath, Static)
        self.createNode(self.templatePath, Template)

    @transaction.atomic
    def createNode(self, path, model, parent=None):

        if self.staticPath in path:
            dirs = self.staticDirs
        else:
            dirs = self.templateDirs
        
        for f in os.listdir(path):
            filePath = os.path.join(path, f)

            if filePath.startswith(BACKUP_FILE_DIR):
                continue

            if dirs:
                create = False
                for dirName in dirs:
                    if filePath.startswith(dirName):
                        if dirName in filePath:
                            create = True
                    else:
                        if filePath in dirName:
                            create = True
            else:
                create = True

            if os.path.isfile(filePath):
                if create:
                    print("Create file node: %s" % filePath)
                    node = model.objects.create(
                        type=FILE,
                        name=f,
                        parent=parent
                    )
            else:
                if create:
                    print("Create folder node: %s" % filePath)
                    node = model.objects.create(
                        type=FOLDER,
                        name=f,
                        parent=parent
                    )
                    self.createNode(filePath, model, parent=node)
         
        # check conflict node
        conflictNodeList = checkVersion(model)


        