#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: CloudServices.py 1197 2021-08-16 06:40:19Z Casey $
#
# Copyright (c) 2021 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2021-08-16 14:40:19 +0800 (Mon, 16 Aug 2021) $
# $Revision: 1197 $

import json
import socket
import tldextract

import requests
import mechanicalsoup

from Pandora.Pyflare import Cloudflare

# services settings
CLOUDFLARE_EMAIL = "lavender.chan@nuwainfo.com"
CLOUDFLARE_API_KEY = "82a8aa6dfd398086161f196d7ce60e34bd74e"

SENTRY_URL = "https://sentry.nuwainfo.com"
SENTRY_EMAIL = "devops@nuwainfo.com"
SENTRY_PASSWORD = '9Ao0pvvSmYh4kJngGAlHfLfVCrxgzB'

HEALTHCHECKS_URL = "https://healthchecks.nuwainfo.com"
HEALTHCHECKS_EMAIL = "devops@nuwainfo.com"
HEALTHCHECKS_PASSWORD = "jWr8vftC7GYXs016jiwQXsLcltDpLB"
HEALTHCHECKS_MIS_API_KEY = "pRss95XL0jcJ1KiaO9xOtKjsLYwi78sI"
HEALTHCHECKS_MIS_PROJECT_LINK = "projects/9649fabb-12d6-415c-b2f2-f132fea69333/"
HEALTHCHECKS_DEFAULT_MIS_INTEGRATIONS = [
    'd0c0fea2-9f50-45ec-aa3b-d12e2e0768cf', # mail to devlops@nuwainfo.com
    'cbe7ed07-289f-4174-9556-daccc66dce7d', # line to bear
]
HEALTHCHECKS_ADMIN_INTEGRATIONS = {
    'Bear': ('devops@nuwainfo.com', 'ifttt://bgGPtp1hdNYgADI613pubm/Healthchecks'),
}

class BaseServices(object):
    
    name = "Base"

    def register(self, managerEmail, ifttt, companyName, projectName, server, domain, aliasDomain=None):
        return {
            
        }
    
    
class CloudflareService(BaseServices):

    name = "Cloudflare DNS"

    def register(self, managerEmail, ifttt, companyName, projectName, server, domain, aliasDomain=None):
        # cf
        cf = Cloudflare(CLOUDFLARE_EMAIL, CLOUDFLARE_API_KEY)
        subdomain = tldextract.extract(domain).subdomain
        zone = '%s.%s' % (tldextract.extract(domain).domain, tldextract.extract(domain).suffix)
        
        # zone id
        response = cf.zones(zone)
        
        result = response.get("result")
        if result:
            zoneID = result[0].get("id", None)
        else:
            zoneID = None
            
        if not zoneID:
            raise RuntimeError("Zone not in Cloudflare: %s" % zone)
        
        # get server ip
        try:
            ip = socket.gethostbyname(server)
        except Exception as e:
            raise RuntimeError("Can't get ip of server: %s" % server)

        domains = []
        domains.append(domain)
        if aliasDomain:
            # aliasDomain 可能會有多個，且用逗號區隔
            aliasDomain = aliasDomain.split(",")
            for alias in aliasDomain:
                domains.append(alias)
        
        # check dns 
        if ip and zoneID:
            finalResult = []
            for domain in domains:
                result = cf.dns_records(zoneID, domain).get('result')
                if not result:
                    # creat dns
                    result = cf.create_record(zoneID, domain, ip)
                    if not result.get('success'):
                        raise RuntimeError("Create Cloudflare DNS error: %s" % result)
                    result = cf.dns_records(zoneID, domain).get('result')
                    result = result[0]
                else:
                    result = result[0]
                    # update
                    result = cf.update_record(zoneID, result["id"], domain, result['ttl'], ip, result['proxied'])
                    result = result["result"]

                finalResult.append(result)

            name = ''
            for result in finalResult:
                name += f'{result.get("name")}, '

            return {
                'zone name': finalResult[0].get("zone_name"), 
                'name': name, 
                'type': finalResult[0].get("type"), 
                'content': finalResult[0].get("content")
            }
            
        raise RuntimeError("Can't get ip of server and zoneID: %s" % server)

class HealthchecksService(BaseServices):

    name = "Healthchechs DNS"
    
    def loginHealthchecks(self):
        # connect 
        browser = mechanicalsoup.StatefulBrowser(user_agent='MechanicalSoup')
        browser.open("%s/accounts/login/" % HEALTHCHECKS_URL)
        
        # login
        browser.select_form('#login-form')
        browser["email"] = HEALTHCHECKS_EMAIL
        browser["password"] = HEALTHCHECKS_PASSWORD
        browser.submit_selected()
        
        return browser
        
    def createAccount(self, managerEmail, password):
        # connect 
        browser = self.loginHealthchecks()
        
        # find user
        browser.open("%s/admin/auth/user/" % HEALTHCHECKS_URL)
        created = False
        for a in browser.page.select("#result_list .field-email a"):
            if a.text == managerEmail:
                created = True
   
        if not created:
            # create user
            browser.open("%s/admin/auth/user/add/" % HEALTHCHECKS_URL)
            browser.select_form("#user_form")
            browser["username"] = managerEmail.split("@")[0]
            browser["password1"] = password
            browser["password2"] = password
            browser.submit_selected(btnName="_continue")
        else:    
            # not create
            return 
                    
        browser.select_form("#user_form")
        browser["email"] = managerEmail
        browser.submit_selected()
    
    def findProject(self, browser, project):
        projectLink = None
        for link in browser.page.select('a'):
            if project in link.text.strip():
                projectLink = link.attrs['href']
        return projectLink
        
    def findIntegrations(self, browser, url, managerName=""):
        # managerName 有的話，會找是此 manager 的。沒有的話會找 unnamed 的
    
        lineIntegration = None
        emailIntegration = None
        
        browser.open(url)
        for div in browser.page.select("table.channels-table tr.kind-email .edit-name"):
            name = div.find(text=True).strip()
            if managerName in name:
                emailIntegration = div.attrs["data-target"].replace("#name-", "")
        
        for div in browser.page.select("table.channels-table tr.kind-apprise .edit-name"):
            name = div.find(text=True).strip()
            if managerName in name:
                lineIntegration = div.attrs["data-target"].replace("#name-", "")

        return emailIntegration, lineIntegration
        
    def renameIntegrations(self, browser, url, integrationId, name):
        browser.open(url)
        browser.select_form('#name-%s form' % integrationId)
        browser["name"] = name
        browser.submit_selected() 
        
    def removeAllChecks(self, browser, url, integrationId):
        browser.open(url)
        
        # create form
        form = browser.page.new_tag("form")
        form["id"] = "removeCheckForm"
        form["action"] = url
        form["method"] = "post"
        channelInput = browser.page.new_tag("input", value=integrationId)
        channelInput["name"] = "channel"
        csrf = browser.page.select("input[name='csrfmiddlewaretoken']")[0].attrs["value"]
        csrfInput = browser.page.new_tag("input", value=csrf)
        csrfInput["name"] = "csrfmiddlewaretoken"
        submitBtn = browser.page.new_tag("input")
        submitBtn["type"] = "submit"
        form.append(channelInput)
        form.append(csrfInput)
        form.append(submitBtn)
        browser.page.select("#checks-modal .modal-content").append(form)
        
        # submit
        browser.select_form('#name-%s form' % integrationId)
        browser.form.form = form
        browser.submit_selected() 
        
    def createIntegrations(self, browser, projectLink, managerEmail, ifttt, managerName=None):
        if not managerName:
            managerName = managerEmail.split("@")[0]
        url = "%s/%sintegrations/" % (HEALTHCHECKS_URL, projectLink)
        
        # 找是此 manager 的 integrations
        emailIntegration, lineIntegration = self.findIntegrations(browser, url, managerName)
        if not emailIntegration:
            # email integration
            browser.open("%s/%sadd_email" % (HEALTHCHECKS_URL, projectLink))
            browser.select_form('.container form')
            browser["value"] = managerEmail
            browser.submit_selected()
            
            # rename
            emailIntegration, lineIntegration = self.findIntegrations(browser, url) # 找 unnamed 的 integrations
            self.renameIntegrations(browser, url, emailIntegration, "email to %s" % managerName)
            
            # remove all checks from this integration
            self.removeAllChecks(browser, url, emailIntegration)
        
        if not lineIntegration:
            # apprise integration
            browser.open("%s/%s/add_apprise/" % (HEALTHCHECKS_URL, projectLink))
            browser.select_form('.container form')
            browser["url"] = ifttt
            browser.submit_selected()
            
            # rename
            emailIntegration, lineIntegration = self.findIntegrations(browser, url) # 找 unnamed 的 integrations
            self.renameIntegrations(browser, url, lineIntegration, "line to %s" % managerName)
            
            # remove all checks from this integration
            self.removeAllChecks(browser, url, lineIntegration)
            
        return self.findIntegrations(browser, url, managerEmail)
        
    def findManagerEmailsFromHealthchecksByProject(self, companyName, projectName):
        # connect 
        browser = self.loginHealthchecks()
       
        # find project
        hchkProjectName = "[%s] %s" % (companyName, projectName)
        projectLink = self.findProject(browser, hchkProjectName) 
        
        if not projectLink:
            return []
            
        # find manage email
        emails = []
        
        projectLink = projectLink.replace("checks/", "") # /EX: projects/9e7208d8-8b72-4872-8859-b781ae952b60/checks/
        browser.open("%s/%sintegrations/" % (HEALTHCHECKS_URL, projectLink))
        for span in browser.page.select("table.channels-table tr.kind-email .channel-details-mini span"):
            emails.append(span.text)
            
        return emails
        
    def findManagerIntegrationsFromHealthchecksByProject(self, companyName, projectName):
        # connect 
        browser = self.loginHealthchecks()
       
        # find project
        hchkProjectName = "[%s] %s" % (companyName, projectName)
        projectLink = self.findProject(browser, hchkProjectName) 
        if not projectLink:
            return []
            
        projectLink = projectLink.replace("checks/", "")
            
        # find manage integrations
        browser.open("%s/%sintegrations/" % (HEALTHCHECKS_URL, projectLink))
        
        integrations = []
        for div in browser.page.select("table.channels-table tr .edit-name"):
            name = div.find(text=True).strip()
            integration = div.attrs["data-target"].replace("#name-", "")
            integrations.append(integration)
            
        return integrations
    
    def findIntegrationsFromMIS(self, managerEmail):
        managerName = managerEmail.split("@")[0]
        
        # connect healthchecks
        headers = {
            "X-Api-Key": HEALTHCHECKS_MIS_API_KEY,
        }
        url = "https://healthchecks.nuwainfo.com/api/v1/channels/"

        channels = json.loads(requests.get(url, headers=headers).text)
        
        lineIntegration = None
        emailIntegration = None
        for channel in channels.get("channels"):
            if managerName in channel.get("name") and channel.get("kind") == "apprise":
                lineIntegration = channel.get("id", None)
            if managerName in channel.get("name") and channel.get("kind") == "email":
                emailIntegration = channel.get("id", None)
        return emailIntegration, lineIntegration
        
    def getHealthchecksAPIKey(self, companyName, projectName):
        # connect 
        browser = self.loginHealthchecks()
       
        # find project
        hchkProjectName = "[%s] %s" % (companyName, projectName)
        projectLink = self.findProject(browser, hchkProjectName) 
        if not projectLink:
            return None
        projectLink = projectLink.replace("checks/", "") # /EX: projects/9e7208d8-8b72-4872-8859-b781ae952b60/checks/
        
        # show API
        browser.open("%s/%ssettings" % (HEALTHCHECKS_URL, projectLink))
        hchkProjectAPIKey = None
        for div in browser.page.select("div.panel-body"):
            if div.h2.text.strip() == "API Access":
                browser.select_form(div.form)
                browser.submit_selected()
                break
                
        # get key     
        for div in browser.page.select("div.panel-body"):
            if div.h2.text.strip() == "API Access":
                hchkProjectAPIKey = div.p.code.text
                break
                
        return hchkProjectAPIKey
        
    def getAPIKeyAndIntegrations(self, companyName, projectName):
        # find healthchecks integrations for ssl and curl
        try:
            hchkAPIKey = self.getHealthchecksAPIKey(companyName, projectName)
            if not hchkAPIKey:
                hchkAPIKey = HEALTHCHECKS_MIS_API_KEY
            integrations = self.findManagerIntegrationsFromHealthchecksByProject(companyName, projectName)
            if not integrations:
                emails = self.findManagerEmailsFromHealthchecksByProject(companyName, projectName)
                integrations = [integration for integration in HEALTHCHECKS_DEFAULT_MIS_INTEGRATIONS]
                for email in emails:
                    emailIntegration, lineIntegration = self.findIntegrationsFromMIS(email)
                    if emailIntegration:
                        integrations.append(emailIntegration)
                    if lineIntegration:
                        integrations.append(lineIntegration)
            integrations = ",".join(integrations)
        except Exception as e:
            # 有錯時，用預設的
            hchkAPIKey = HEALTHCHECKS_MIS_API_KEY
            integrations = [integration for integration in HEALTHCHECKS_DEFAULT_MIS_INTEGRATIONS]
            integrations = ",".join(integrations)
            
        return hchkAPIKey, integrations
        

    def register(self, managerEmail, ifttt, companyName, projectName, server, domain, aliasDomain=None):
        # connect 
        browser = self.loginHealthchecks()
       
        # find project
        hchkProjectName = "[%s] %s" % (companyName, projectName)
        projectLink = self.findProject(browser, hchkProjectName) 
        
        if not projectLink:
            browser.select_form('#add-project-modal form')
            browser["name"] = hchkProjectName
            browser.submit_selected()
            
            projectLink = self.findProject(browser, hchkProjectName)
            
        projectLink = projectLink.replace("checks/", "") # /EX: projects/9e7208d8-8b72-4872-8859-b781ae952b60/checks/

        # create API
        browser.open("%s/%ssettings" % (HEALTHCHECKS_URL, projectLink))
        for div in browser.page.select("div.panel-body"):
            if div.h2.text.strip() == "API Access":
                browser.select_form(div.form)
                browser.submit_selected()
                break
                
        # show key     
        for div in browser.page.select("div.panel-body"):
            if div.h2.text.strip() == "API Access":
                hchkProjectAPIKey = div.p.code.text
                break
                
        # invite-team-member-modal
        browser.select_form('#invite-team-member-modal form')
        browser["email"] = managerEmail
        browser.submit_selected()
        
        # integrations to this project
        emailIntegration, lineIntegration = self.createIntegrations(
            browser, projectLink, managerEmail, ifttt)
        # admin integrations to this project
        for adminName, data in HEALTHCHECKS_ADMIN_INTEGRATIONS.items():
            emailIntegration, lineIntegration = self.createIntegrations(
                browser, projectLink, data[0], data[1], managerName=adminName)
        
        return {
            'Healthchechs API key': hchkProjectAPIKey, 
            'Document': "Please see Deploy document '如何執行排程程式(Crontab 寫法)' and set API key to settings.py.",
            "Suggestion": "Please go to %s to check emails." % managerEmail,
        }
        
class SentryService(BaseServices):

    name = "Sentry DSN"
    
    def loginSentry(self):
        # connect 
        browser = mechanicalsoup.StatefulBrowser(user_agent='MechanicalSoup')
        browser.open("%s/auth/login/nuwa/" % SENTRY_URL)
        
        # login
        browser.select_form('form.form-stacked')
        browser["username"] = SENTRY_EMAIL
        browser["password"] = SENTRY_PASSWORD
        browser.submit_selected()
        
        return browser
        
    def createAccount(self, managerEmail, password):
        # connect 
        browser = self.loginSentry()
      
        # find user
        browser.open("%s/admin/sentry/user/" % SENTRY_URL)
        created = False
        for td in browser.page.select("#result_list tr th"):
            if td.text == managerEmail:
                created = True

        if not created:
            # create user
            browser.open("%s/admin/sentry/user/add/" % SENTRY_URL)
            browser.select_form("#user_form")
            browser["username"] = managerEmail
            browser["password1"] = password
            browser["password2"] = password
            browser.submit_selected(btnName="_continue")
        else:    
            # not create
            return 
                    
        browser.select_form("#user_form")
        browser["email"] = managerEmail
        browser.submit_selected()

    def register(self, managerEmail, ifttt, companyName, projectName, server, domain, aliasDomain=None):
        # connect 
        browser = self.loginSentry()
        
        # find team
        created = False
        for link in browser.page.select('a'):
            if link.text.strip() == companyName and "nuwa/teams" in link.attrs['href']:
                created = True
                break
        
        # create team 
        if not created:
            browser.open("%s/organizations/nuwa/teams/new/" % SENTRY_URL)
            browser.select_form('form.form-stacked')
            browser.form["ctwizard-0-name"] = companyName
            browser.submit_selected()
            
            browser.select_form('form.form-stacked')
            op = browser.page.new_tag("input", value="skip")
            op["name"] = "op"
            browser.form.form.append(op)
            
            browser.submit_selected()
            
        # find project
        created = False
        for link in browser.page.select('a'):
            if link.text.strip() == projectName and "nuwa/" in link.attrs['href']:
                if not "teams" in link.attrs['href']:
                    if link.parent.parent.parent.h3.select('a')[3].text.strip() == companyName:
                        created = True
                        break
        
        # create project
        if not created:
            teamURL = None
            for link in browser.page.select('a'):
                if link.text.strip() == companyName and "nuwa/teams" in link.attrs['href']:
                    teamURL = link.attrs['href']
                    break
                    
            teamSlug = teamURL.strip("/").split("/")[-1]    
            browser.open("%s/organizations/nuwa/projects/new/?team=%s" % (SENTRY_URL, teamSlug))
            browser.select_form('.body form')
            browser["name"] = projectName
            browser["platform"] = "django"
            browser.submit_selected()
            
        # get dsn
        projectURL = None
        
        browser.open("%s/nuwa/" % SENTRY_URL)
        for link in browser.page.select('a'):
            if link.text.strip() == projectName and "nuwa/" in link.attrs['href']:
                if not "teams" in link.attrs['href']:
                    if link.parent.parent.parent.h3.select('a')[3].text.strip() == companyName:
                        projectURL = link.attrs['href']
                        break
        
        browser.open("%s%ssettings/keys/" % (SENTRY_URL, projectURL))
        
        dsn = browser.page.select("code.clippy")[0].text
        
        return {
            "DSN": dsn,
            'Document': "Please see Iuno document '整合 Iuno 步驟(settings.py)' and set dsn to settings.py.", 
        }