#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11103 2018-06-13 14:19:09Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-06-13 22:19:09 +0800 (週三, 13 六月 2018) $
# $Revision: 11103 $

import urllib
import re
import unicodedata

from django import forms
from django.contrib import admin
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from aldryn_newsblog.admin import ArticleAdmin, ArticleAdminForm
from aldryn_newsblog.models import Article
from djangocms_text_ckeditor.models import Text

from Zephyrus.blog_extension import views

class ArticleAdminForm2(ArticleAdminForm):
    slug2 = forms.CharField(
        label=_('slug'),
        required=False, max_length=255, 
        help_text=_(
            'Used in the URL. If changed, the URL will change. '
            'Clear it to have it re-created automatically.')
    )

    class Meta:
        model = Article
        fields = [
            'app_config',
            'categories',
            'featured_image',
            'is_featured',
            'is_published',
            'lead_in',
            'meta_description',
            'meta_keywords',
            'meta_title',
            'owner',
            'related',
            #'slug',
            'tags',
            'title',
        ]

class ArticleAdmin2(ArticleAdmin):
    form = ArticleAdminForm2

    fieldsets = (
        (None, {
            'fields': (
                'title',
                'author',
                'publishing_date',
                'is_published',
                'is_featured',
                'featured_image',
            )
        }),
        (_('Meta Options'), {
            'classes': ('collapse',),
            'fields': (
                'slug2',
                'meta_title',
                'meta_description',
                'meta_keywords',
            )
        }),
        (_('Advanced Settings'), {
            'classes': ('collapse',),
            'fields': (
                'tags',
                'categories',
                'related',
                'owner',
                'app_config',
            )
        }),
    )

    def get_form(self, request, obj=None, **kwargs):
        form = super(ArticleAdmin2, self).get_form(request, obj, **kwargs)
        if obj:
            form.base_fields['slug2'].initial = obj.slug
        else:
            form.base_fields['slug2'].initial = ''
        return form

    def response_add(self, request, obj, post_url_continue=None):
        body = _("double click here to edit article content")
        textPlugin = Text.objects.create(
            placeholder=obj.content,
            language=obj.language_code,
            body=body, plugin_type='TextPlugin')

        slug = request.POST.get('slug2')
        if slug:
            obj.slug = slug
        else:
            obj.slug = obj.title
        obj.save()
        
        return super(ArticleAdmin2, self).response_add(
            request, obj, post_url_continue=None)

    def response_change(self, request, obj):
        slug = request.POST.get('slug2')
        if slug:
            obj.slug = slug
        else:
            obj.slug = obj.title
        obj.save()

        return super(ArticleAdmin2, self).response_change(request, obj)

admin.site.unregister(Article)
admin.site.register(Article, ArticleAdmin2)
