#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11641 2019-06-19 07:33:01Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-19 15:33:01 +0800 (週三, 19 六月 2019) $
# $Revision: 11641 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class URL(models.Model):
    url = models.CharField(max_length=400, editable=False, db_index=True)
    viewCount = models.PositiveIntegerField(
        verbose_name=_("View count"), default=0)
    likeCount = models.PositiveIntegerField(
        verbose_name=_("Like count"), default=0)
    commentCount = models.PositiveIntegerField(
        verbose_name=_("Comment count"), default=0)

    class Meta:
        verbose_name = _("URL")
        verbose_name_plural = _("URLs")
