#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 13369 2022-01-08 11:52:12Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2022-01-08 19:52:12 +0800 (週六, 08 一月 2022) $
# $Revision: 13369 $

import os

from django.conf import settings

# FIXME: 看 Iuno 該怎麼設定
STATIC_DIR = None
if not settings.DEBUG:
    if hasattr(settings, "STATIC_ROOT"):
        STATIC_DIR = settings.STATIC_ROOT
else:
    if hasattr(settings, "STATICFILES_DIRS"):
        try:
            STATIC_DIR = settings.STATICFILES_DIRS[0]
        except Exception as e:
            pass
        
if not STATIC_DIR:
    STATIC_DIR = os.path.join(settings.BASE_DIR, "static")

if not hasattr(settings, "TEMPLATE_EDITOR_TEMPLATE_DIRS"):
    # 找尋 settings.py 的 TEMPLATES 內的設定當 TEMPLATE_DIR
    TEMPLATE_DIRS = None
    if hasattr(settings, "TEMPLATES"):
        try:
            TEMPLATE_DIRS = settings.TEMPLATES[0]['DIRS']
        except Exception as e:
            pass

    if not TEMPLATE_DIRS:
        TEMPLATE_DIRS = [
            os.path.join(settings.BASE_DIR, "templates"),
        ]
else:
    TEMPLATE_DIRS = settings.TEMPLATE_EDITOR_TEMPLATE_DIRS

BACKUP_DIR_NAME = "_Iuno.template_editor_backup" 

BACKUP_FILE_DIR = os.path.join(
    STATIC_DIR, BACKUP_DIR_NAME)

if not os.path.isdir(BACKUP_FILE_DIR):
    os.mkdir(BACKUP_FILE_DIR)

import six

def toBytes(s):
    return s if six.PY2 else s.encode()
