#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11660 2019-07-21 13:24:58Z Trista $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $ (last)
# $Date: 2019-07-21 22:24:58 +0900 (週日, 21 七月 2019) $
# $Revision: 11660 $

from django.contrib.sites.models import Site
from django.db import models
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _

@python_2_unicode_compatible
class Redirect(models.Model):
    site = models.ForeignKey(
        Site,
        related_name='siteName',
    )
    old_path = models.CharField(_('redirect from'), max_length=400, db_index=True,
        help_text=_(
            "This should be an absolute path, "
            "excluding the domain name. Example: '/events/search/'."))
    new_path = models.CharField(_('redirect to'), max_length=400, blank=True,
        help_text=_(
            "This can be either an absolute path (as above)"
            " or a full URL starting with 'http://'."))

    class Meta:
        verbose_name = _('redirect')
        verbose_name_plural = _('redirects')
        unique_together = (('site', 'old_path'),)
        ordering = ('old_path',)

    def __str__(self):
        return "%s ---> %s" % (self.old_path, self.new_path)
    
