/**
$Id: editor_plugin_src.js 9594 2016-03-18 12:59:58Z Judy $

Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Judy $
$Date: 2016-03-18 20:59:58 +0800 (Fri, 18 Mar 2016) $
$Revision: 9594 $
*/

/* 
 * Reference: http://www.tinymce.com/wiki.php/Creating_a_plugin
 *
 * Compiling JavaScript (editor_plugin_src.js -> editor_plugin.js)
 * TinyMCE doesn't care about editor_plugin_src.js. 
 * You need to use jstrim(http://javascriptcompressor.com/) to convert it 
 * to editor_plugin.js, which is essentially a version of editor_plugin_src.js 
 * with all the comments and whitespace stripped out.
*/ 

(function() {
	// Load plugin specific language pack
	tinymce.PluginManager.requireLangPack('variablePlugin');

	tinymce.create('tinymce.plugins.VariablePluginPlugin', {
		/**
		 * Initializes the plugin, this will be executed after the plugin has 
         * been created.
		 * This call is done before the editor instance has finished it's 
         * initialization so use the onInit event
		 * of the editor instance to intercept that event.
		 *
		 * @param {tinymce.Editor} ed Editor instance that the plugin is 
         *                         initialized in.
		 * @param {string} url Absolute URL to where the plugin is located.
		 */
		init : function(ed, url) {
			// Register the command so that it can be invoked by using 
            // tinyMCE.activeEditor.execCommand('mceFacebook');
			ed.addCommand('mceVariablePlugin', function() {
				ed.windowManager.open({
					file : url + '/Dialog.html',
					width : 500,
					height : 200,
					inline : 5
				}, {
					plugin_url : url, // Plugin absolute URL
					some_custom_arg : 'custom arg' // Custom argument
				});
			});

			// Register upload button
			ed.addButton('variablePlugin', {
				title : ed.getLang('variablePlugin.title'),
				cmd : 'mceVariablePlugin',
				image : url + '/img/VariablePlugin.gif'
			});

			// Add a node change handler, selects the button in the UI when a 
            // image is selected
			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('variablePlugin', n.nodeName == 'IMG');
			});
		},

		/**
		 * Creates control instances based in the incomming name. This method 
         * is normally not needed since the addButton method of the 
		 * tinymce.Editor class is a more easy way of adding buttons
		 * but you sometimes need to create more complex controls like 
         * listboxes, split buttons etc then this method can be used to create
		 * those.
		 *
		 * @param {String} n Name of the control to create.
		 * @param {tinymce.ControlManager} cm Control manager to use inorder to 
         *                                 create new control.
		 * @return {tinymce.ui.Control} New control instance or null if no 
         *                              control was created.
		 */
		createControl : function(n, cm) {
			return null;
		},

		/**
		 * Returns information about the plugin as a name/value array.
		 * The current keys are longname, author, authorurl, infourl and 
         * version.
		 *
		 * @return {Object} Name/value array containing information about the 
         *                  plugin.
		 */
		getInfo : function() {
			return {
				longname : 'Variable plugin',
				author : 'Yachu',
				authorurl : 'http://www.tracedig.com',
				infourl : 
                    'http://www.tracedig.com/TinyMCE:Plugins/variablePlugin',
				version : "1.0"
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('variablePlugin', tinymce.plugins.VariablePluginPlugin);
})();