#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_pages.py 9976 2017-05-16 06:31:28Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-16 14:31:28 +0800 (週二, 16 五月 2017) $
# $Revision: 9976 $

import os
import logging

from django.core.management.base import BaseCommand
from django.conf import settings
from django.db import transaction
from cms.api import create_page

from Zephyrus.boilerplate.management.commands import TEMPLATES_DIR_PATH

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

class Command(BaseCommand):

    help = 'Auto create all pages.'

    @transaction.atomic
    def handle(self, *args, **options):
        print TEMPLATES_DIR_PATH
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
         if 'index.html' in files:
             homePage = create_page(
                 'index', 'index.html', settings.LANGUAGE_CODE, 
                 published=True)
             logger.info('Create homepage by index.html')
         else:
             logger.error('No templates name index.html.')
             break

         for template in files:
             name = template[:template.index(".html")]
             if name == 'index':
                 continue
             create_page(
                 name, template, settings.LANGUAGE_CODE, 
                 parent=homePage, published=True)
             logger.info('Create %s page by %s' % (name, template))
        logger.info('All OK!!')


