/**
$Id: Subscriber.js 9579 2016-03-09 01:43:46Z Judy $

Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Judy $
$Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
$Revision: 9579 $
*/

var SubscriberHandler = function(statusNames, statusCodes,
                                 staticInfo, translateInfo) {
    
    this.imageUrl = staticInfo.imageUrl
    this.historyLink = staticInfo.historyLink;
    this.changeListLink = staticInfo.changeListLink;
    
    this.translateInfo = translateInfo;
    
    this.startAddr = 0;
    this.hasMore = false;
    this.statusNames = statusNames;
    this.statusCodes = statusCodes;
    this.doLoad = true;
    
    this.$table = $('#emailTable');
    this.$filterTabs;
    this.$currentCountField = $('#currentCount');
    this.$totalCountField = $('#totalCount');
    
    this.$searchBtn = $('#search');
    this.$searchInput = $('#searchContent');
    this.$searchForm = $('#searchForm');
    
    this.getDataField = function() {
        return $('tr[name!=title]', this.$table);
    };
    
    this.getStatusCodeById = function(id) {
        var status = '';
        id = id.split('_');
        if (id.length > 1) {
            status = id[1];
        }
        return status;
    };
    
    /*
     * Get current filter's status code.
     *
     * @return {Integer} Status code.
     */
    this.getCurrentStatusCode = function() {
        var $obj = this.$filterTabs.filter('.current');
        var id = $obj.attr('id');
        return this.getStatusCodeById(id);        
    };
    
    /*
     * Create filters by all status.
     */
    this.buildFilterTabs = function() {
        $('#filter').append(
            '<a id="allFilter" name="filter" href="javascript:void(0)" ' +
            'class="current">' + this.translateInfo['all'] + '</a> | ');
        for (var i = 0; i < this.statusNames.length; i++) {
            var name = this.statusNames[i];
            var code = this.statusCodes[i];
            $('#filter').append(
                '<a id="filter_' + code + 
                '" name="filter" href="javascript:void(0)">' + 
                name + '</a> | ');
        }
        this.$filterTabs = $('[name=filter]');
    };
    
    /*
     * Bind events.
    */
    this.bindEvents = function() {
        var parent = this;
        parent.$filterTabs.click(function() {
            parent.$filterTabs.removeClass('current');
            $(this).addClass('current');

            parent.getDataField().remove();
            parent.getHistory();
        });

        $(document).scroll(function() {
            if (!parent.hasMore) {
                return false;
            }
            var currentScrollTop = $(window).scrollTop() + $(window).height();
            var totalScrollTop = $(document).height();
            var percent = (currentScrollTop / totalScrollTop) * 100;

            if (percent >= 90 && parent.doLoad) {
                parent.doLoad = false;
                var data = {'start': parseInt(parent.startAddr) + 20};
                parent.getHistory(data);
            }
        });
        
        // Search events.
        parent.$searchBtn.click(function() {
            $('#emailTable tr[name!=title]').remove();
            parent.getHistory();
        });
        
        $('#clean').click(function() {
            parent.$searchInput.val('');
        });
        
        parent.$searchForm.submit(function() {
            //parent.$searchBtn.click();
            return false;
        });
    };
    
    /*
     * Get status name by status code.
     * 
     * @param {Integer} statusCode Status code.
     */
    this.getStatusName = function(statusCode) {
        var addr = this.statusCodes.indexOf(statusCode);
        return this.statusNames[addr];
    };
    
    /*
     * Render subscribers's data to table.
     *
     * @param {Array} record A Array of subscribers data.
     */
    this.renderData = function(record) {
        for (var i = 0; i < record.length; i++) {
            var data = record[i];
            var trObj = $('<tr name="forSearch" code="' + data.status + 
                          '"></tr>');
            trObj.append($(
                '<td><a href="' + this.changeListLink + 
                data.contact.id + '">' + 
                data.contact.name + ' (' + data.contact.email + ')' + 
                '</a></td>'));
            trObj.append($('<td>' + data.creationDate + '</td>'));
            trObj.append($('<td>' + this.getStatusName(data.status) + '</td>'));
            this.$table.append(trObj);
        }
    };
    
    /*
     * Get subscribers data with data.
     *
     * @param {Object} data GET data for query.
     */
    this.getHistory = function (data) {
        var parent = this;
        var $table = parent.$table;
        if (typeof(data) == 'undefined') {
            data = {};
        }
        
        var status = parent.getCurrentStatusCode();
        if (status != '') {
            data['status'] = status;
        }
        var keyword = parent.$searchInput.val();
        keyword = $.trim(keyword);
        if (keyword) {
            data['keyword'] = keyword;;
        }

        $table.append(
            '<tr id="loadingTr"><td colspan="3">' + 
            '<img src="' + this.imageUrl + 'images/base/Loading.gif" /> ' +
            this.translateInfo['loading'] + '</td></tr>');
            
        $.ajax({
            type: "GET",
            data: data,
            url: parent.historyLink,
            dataType: "jsonp",
            jsonp: "jsonpcallback",
            crossDomain: true,
            success: function (response) {
                $('#loadingTr').remove();
                var hasMore = response.more;
                var content = response.content;
                parent.renderData(content);
                if (hasMore) {
                    parent.doLoad = true;
                }
                else {
                    if (content.length == 0) {
                        // Show nothing have found message.
                        $table.append(
                            '<tr><td colspan="3">' + 
                            parent.translateInfo['notFound'] + 
                            '</td></tr>');
                    }
                }
                parent.startAddr = response.startNum;
                parent.hasMore = hasMore;
                var curCount = $('tr[name=forSearch]', parent.$table).length;
                parent.$currentCountField.text(curCount);
                parent.$totalCountField.text(response.totalNum);
            },
            error: function() {
                $('#loadingTr').remove();
                $table.append(
                    '<tr><td colspan="3">' + 
                    parent.translateInfo['unknownError'] + 
                    '</td></tr>');
            }
        });
    };

};