
import requests
import json
import re

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.contrib import admin
from django.utils.translation import ugettext as _
from django.conf import settings
from django.utils.safestring import mark_safe
from django.template.loader import select_template

from Zephyrus.map import settings as mapSettings
from Zephyrus.map.models import Map, MapPosition
from boto.ec2 import instance


class Position(object):
    def __init__(self, region, name, tel, email, coordinate):
        self.region = region
        self.name = name
        self.tel = tel
        self.email = email
        self.coordinate = coordinate

class PositionInline(admin.StackedInline):
    model = MapPosition
    # form = FormFieldInlineForm
    extra = 1


    def get_positions(self, request, obj=None):
        fields = (
            ('region', 'name', 'tel', 'email', 'coordinate')
        )


        fieldsets = (
            (None, {
                'fields': fields
            }),
        )
        return fieldsets



class MapPlugin(CMSPluginBase):
    model = Map
    module = _("Map")
    name = _("Map")
    inlines = (PositionInline, )
    render_template = mapSettings.MAP_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            mapSettings.MAP_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):

        positionList = []
        for position in instance.positions.all():
            spot = Position(
                position.region, 
                position.name,
                position.tel,
                position.email,
                position.coordinate,
            )
        
            positionList.append(spot)
        print(positionList)
        context.update({
            'positionList': positionList,
            'apiKey': instance.apiKey,
        })

        return context




plugin_pool.register_plugin(MapPlugin)
