#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 12398 2020-07-16 10:04:42Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2020-07-16 19:04:42 +0900 (週四, 16 七月 2020) $
# $Revision: 12398 $

import os
from django.test import TestCase

from Iuno import shop

class TestAttachSettings(TestCase):
    
    def runTest(self):
        
        settingsContent = {
            'INSTALLED_APPS': (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),

            "MIDDLEWARE": (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),

            "ROOT_URLCONF": 'TemplatesShop.urls',

            'DATABASES': {
                'default': {
                    'ENGINE': 'django.db.backends.sqlite3',
                    'NAME': os.path.join('BASE_DIR', 'db.sqlite3'),
                }
            },

            "DEBUG": True,

            '__file__': '/Users/Ming/Documents/Nuwa_mercurius/Projects/TemplatesShop/TemplatesShop/settings.pyc',

            "TEMPLATES": [
                {
                    'BACKEND': 'django.template.backends.django.DjangoTemplates',
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            'django.contrib.messages.context_processors.messages',
                        ],
                    },
                },
            ],

            'DEFAULT_FROM_EMAIL': 'test@nuwainfo.com',
            'BASE_DIR': 'ddd'
        }
        
        shop.attachSettings(settingsContent)
        
        installedAppsSettings = {
            'INSTALLED_APPS': [
                'django.contrib.admin', 
                'django.contrib.auth', 
                'django.contrib.contenttypes', 
                'django.contrib.sessions', 
                'django.contrib.messages', 
                'django.contrib.staticfiles', 
                'django.contrib.sites', 
                'django.contrib.flatpages', 
                'django.contrib.humanize', 
                'widget_tweaks', 
                'sorl.thumbnail', 
                'oscar', 
                'oscar.apps.analytics', 
                'oscar.apps.checkout', 
                'oscar.apps.address', 
                'oscar.apps.shipping', 
                'oscar.apps.catalogue', 
                'oscar.apps.catalogue.reviews', 
                'oscar.apps.partner', 
                'oscar.apps.basket', 
                'oscar.apps.payment', 
                'oscar.apps.offer', 
                'oscar.apps.order', 
                'oscar.apps.customer', 
                'oscar.apps.search', 
                'oscar.apps.voucher', 
                'oscar.apps.wishlists', 
                'oscar.apps.dashboard', 
                'oscar.apps.dashboard.reports', 
                'oscar.apps.dashboard.users', 
                'oscar.apps.dashboard.orders', 
                'oscar.apps.dashboard.catalogue', 
                'oscar.apps.dashboard.offers', 
                'oscar.apps.dashboard.partners', 
                'oscar.apps.dashboard.pages', 
                'oscar.apps.dashboard.ranges', 
                'oscar.apps.dashboard.reviews', 
                'oscar.apps.dashboard.vouchers', 
                'oscar.apps.dashboard.communications', 
                'oscar.apps.dashboard.shipping', 
                'haystack', 
                'treebeard', 
                'django_tables2', 
                'Iuno.shop', 
                'Iuno.shop.promotions', 
                'Iuno.shop.dashboard_promotions', 
                'ckeditor', 
                'ckeditor_uploader'
            ],
        }
        
        self.assertListEqual(settingsContent['INSTALLED_APPS'],
                             installedAppsSettings['INSTALLED_APPS'])

if __name__ == "__main__":
    testAttachSettings = TestAttachSettings()
    testAttachSettings.runTest()