#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 10686 2017-12-26 11:18:15Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-12-26 19:18:15 +0800 (Tue, 26 Dec 2017) $
# $Revision: 10686 $

from django.contrib import admin

from emencia.django.newsletter.models import Newsletter

from Theophrastus.newsletter_extension.models import Header, Footer
from Theophrastus.newsletter_extension.forms import HeaderTinyMCEForm
from Theophrastus.newsletter_extension.forms import FooterTinyMCEForm

class HeaderTinyMCEAdmin(admin.ModelAdmin):
    list_display=['title']
    form = HeaderTinyMCEForm

admin.site.register(Header, HeaderTinyMCEAdmin)

class FooterTinyMCEAdmin(admin.ModelAdmin):
    list_display=['title']
    form = FooterTinyMCEForm

admin.site.register(Footer, FooterTinyMCEAdmin)
