#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 12366 2020-06-19 06:41:16Z Andy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2020-06-19 14:41:16 +0800 (Fri, 19 Jun 2020) $
# $Revision: 12366 $

from django.conf import settings
from django.contrib import admin
from django.utils.translation import ugettext as _
from django.utils.html import format_html

from emencia.django.newsletter.models import Newsletter

from Theophrastus.editor.admin import NewsletterTinyMCEAdmin

def attach(data, attachData):
    data = list(data)
    data.extend(attachData)
    newData = tuple(data)
    del data
    return newData

def getFieldset(fieldsets):
    _fieldsets = list(fieldsets)
    for (name, d) in fieldsets:
        if 'classes' in d:
            d.pop('classes')
    return fieldsets

class NewsletterStatisticsAdmin(NewsletterTinyMCEAdmin):

    def statistics_link(self, newsletter):
        """
        Display link for statistics(override).
        """
        """Display link for statistics"""
        if (newsletter.status == Newsletter.SENDING or
            newsletter.status == Newsletter.SENT):
            return format_html('<a href="%s">%s</a>' % (
                   newsletter.getStatisticsUrl(), _('View statistics')))
        else:
            return _('Not available')
    statistics_link.allow_tags = True
    statistics_link.short_description = _('Statistics')

    def subscriberLink(self, newsletter):
        """
        Display link for subscribers.
        """
        if (newsletter.status == Newsletter.SENDING or
            newsletter.status == Newsletter.SENT):
            return format_html('<a href="%s">%s</a>' % (
                   newsletter.getSubscriberUrl(), _('View subscribers')))
        else:
            return _('Not available')

    subscriberLink.allow_tags = True
    subscriberLink.short_description = _('Subscribers')

    fieldsets = getFieldset(NewsletterTinyMCEAdmin.fieldsets)

    list_display = attach(
        NewsletterTinyMCEAdmin.list_display, ['subscriberLink'])

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterStatisticsAdmin)
