#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 12803 2021-03-18 07:29:01Z Lavender $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-03-18 15:29:01 +0800 (週四, 18 三月 2021) $
# $Revision: 12803 $

from django.contrib import admin
from django.conf import settings
from django.utils.translation import ugettext as _

if settings.DEBUG:
    from emencia.django.newsletter.models import ContactMailingStatus, Link

    admin.site.unregister(ContactMailingStatus)
    admin.site.unregister(Link)

from django_ses.models import SESStat
# Unregister.
admin.site.unregister(SESStat)

from tagging.models import Tag, TaggedItem
# Unregister.
admin.site.unregister(Tag)
admin.site.unregister(TaggedItem)

from django.db import models
from django.forms import Textarea

from emencia.django.newsletter.admin.mailinglist import MailingListAdmin
from emencia.django.newsletter.models import MailingList

admin.site.unregister(MailingList)

class NewMailingListAdmin(MailingListAdmin):
    formfield_overrides = {
        models.TextField: {'widget': Textarea(attrs={'rows': '', 'cols': ''})},
    }

admin.site.register(MailingList, NewMailingListAdmin)

import types


from emencia.django.newsletter.admin.newsletter import NewsletterAdmin
from emencia.django.newsletter.mailer import Mailer

from Theophrastus.cloud.Mailer import CloudMailer

ENABLE_FAKE_MAIL = settings.ENABLE_FAKE_MAIL
ENABLE_FAKE_SMTP = settings.ENABLE_FAKE_SMTP

def send_mail_test(self, request, queryset):
    """
    Send newsletter in test.
    """
    for newsletter in queryset:
        if newsletter.test_contacts.count():
            try:

                # CloudMailer 會判斷是一般的 SMTP Server 還是 Cloud SMTP Server
                mailer = CloudMailer(
                    newsletter, test=True,
                    fakeMail=ENABLE_FAKE_MAIL,
                    fakeSMTP=ENABLE_FAKE_SMTP
                )

                mailer.run()
            except Exception as e:
                self.message_user(
                    request,
                    _('Unable send newsletter, due to errors within HTML.'))
                continue
            self.message_user(
                request, _('%s successfully sent.') % newsletter)
        else:
            self.message_user(
                request,
                _('No test contacts assigned for %s.') % newsletter)

send_mail_test.short_description = _('Send test email')

# NewsletterAdmin.send_mail_test = types.MethodType(
                                    # send_mail_test, None, NewsletterAdmin)
NewsletterAdmin.send_mail_test = types.MethodType(
                                    send_mail_test, NewsletterAdmin)
                                    
                                    
                                    
                                    
