#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 12286 2020-05-31 07:53:29Z Casey $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-05-31 15:53:29 +0800 (Sun, 31 May 2020) $
# $Revision: 12286 $
import datetime

from django import forms
from django.contrib import admin

from Iuno.maintenance.models import MaintenanceHistory, MaintenanceSetting

@admin.register(MaintenanceHistory)
class MaintenanceHistoryAdmin(admin.ModelAdmin):
    readonly_fields = ('date', 'status')
    list_display = ('date', 'status')
    search_fields = ('date', 'status')

    def has_add_permission(self, request, obj=None):
        return False
    def has_delete_permission(self, request, obj=None):
        return False

@admin.register(MaintenanceSetting)
class MaintenanceSettingAdmin(admin.ModelAdmin):
    list_display = ('status', 'fixedUI', 'openFrontEnd')
    list_editable = list_display
    list_display_links = None

#     def get_changeform_initial_data(self, request):
#         return {'status': 'No', 'fixedUI': 'True'}

