#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2013-01-30 12:13:45 +0800$
# $Revision: 9579 $

from django.views.decorators.csrf import csrf_exempt
from django.template.loader import render_to_string
from django.core.urlresolvers import reverse
from django.shortcuts import redirect

from django.contrib.admin.views.decorators import staff_member_required

from Iuppiter.extension.views import jsonpCallback

from Theophrastus.models import Newsletter
from Theophrastus.newsletter_extension.models import Header, Footer

@staff_member_required
@jsonpCallback(noPadding=True)
def getDefaultHeaderText(request):

    c = render_to_string('NewsletterDefaultHeader.html')
    return {'content': unicode(c)}

@staff_member_required
@jsonpCallback(noPadding=True)
def getDefaultFooterText(request):

    c = render_to_string('NewsletterDefaultFooter.html')
    return {'content': unicode(c)}

@staff_member_required
def createOrModifyHeader(request):
    """
    Create footer if not exists.
    Redirect to header's change form page.
    """
    try:
        header = Header.objects.all()[0]
    except:
        c = render_to_string('NewsletterDefaultHeader.html')
        header = Header.objects.create(content=c)
        header.save()
    return redirect(
        reverse('admin:newsletter_extension_header_change', args=[header.id]))

@staff_member_required
def createOrModifyFooter(request):
    """
    Create footer if not exists.
    Redirect to footer's change form page.
    """
    try:
        footer = Footer.objects.all()[0]
    except:
        c = render_to_string('NewsletterDefaultFooter.html')
        footer = Footer.objects.create(content=c)
        footer.save()
    return redirect(
        reverse('admin:newsletter_extension_footer_change', args=[footer.id]))

@csrf_exempt
@jsonpCallback(noPadding=True)
def getNewsletterInfo(request):
    try:
        newsletterId = request.GET.get('id', None)
        if newsletterId is None:
            raise RuntimeError('Invalid id.')
        else:
            newsletterId = int(newsletterId)
            newsletter = Newsletter.objects.get(id=newsletterId)
            formatStr = '%Y-%m-%d %H:%M:%S'
            return {
                'id': newsletter.id,
                'status': newsletter.status,
                'sendingDate': newsletter.sending_date.strftime(formatStr),
                'slug': newsletter.slug
            }
    except Exception as e:
        return {'error': str(e)}


