#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 12438 2020-07-30 11:44:37Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2020-07-30 19:44:37 +0800 (Thu, 30 Jul 2020) $
# $Revision: 12438 $

import os
from django.test import TestCase

from Iuno import shop

class TestAttachSettings(TestCase):
    
    def runTest(self):
        
        settingsContent = {
            'INSTALLED_APPS': (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),

            "MIDDLEWARE": (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),

            "ROOT_URLCONF": 'TemplatesShop.urls',

            'DATABASES': {
                'default': {
                    'ENGINE': 'django.db.backends.sqlite3',
                    'NAME': os.path.join('BASE_DIR', 'db.sqlite3'),
                }
            },

            "DEBUG": True,

            '__file__': '/Users/Ming/Documents/Nuwa_mercurius/Projects/TemplatesShop/TemplatesShop/settings.pyc',

            "TEMPLATES": [
                {
                    'BACKEND': 'django.template.backends.django.DjangoTemplates',
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            'django.contrib.messages.context_processors.messages',
                        ],
                    },
                },
            ],

            'DEFAULT_FROM_EMAIL': 'test@nuwainfo.com',
            'BASE_DIR': 'ddd'
        }
        
        shop.attachSettings(settingsContent)
        
        installedAppsSettings = {
            'INSTALLED_APPS': [
                'django.contrib.admin', 
                'django.contrib.auth', 
                'django.contrib.contenttypes', 
                'django.contrib.sessions', 
                'django.contrib.messages', 
                'django.contrib.staticfiles', 
                'django.contrib.sites', 
                'django.contrib.flatpages', 
                'django.contrib.humanize', 
                'widget_tweaks', 
                'sorl.thumbnail', 
                'oscar.config.Shop', 
                'oscar.apps.analytics.apps.AnalyticsConfig', 
                'oscar.apps.checkout.apps.CheckoutConfig', 
                'oscar.apps.address.apps.AddressConfig', 
                'oscar.apps.shipping.apps.ShippingConfig', 
                'oscar.apps.catalogue.apps.CatalogueConfig', 
                'oscar.apps.catalogue.reviews.apps.CatalogueReviewsConfig', 
                'oscar.apps.communication.apps.CommunicationConfig', 
                'oscar.apps.partner.apps.PartnerConfig', 
                'oscar.apps.basket.apps.BasketConfig', 
                'oscar.apps.payment.apps.PaymentConfig', 
                'oscar.apps.offer.apps.OfferConfig', 
                'oscar.apps.order.apps.OrderConfig', 
                'oscar.apps.customer.apps.CustomerConfig', 
                'oscar.apps.search.apps.SearchConfig', 
                'oscar.apps.voucher.apps.VoucherConfig', 
                'oscar.apps.wishlists.apps.WishlistsConfig', 
                'oscar.apps.dashboard.apps.DashboardConfig', 
                'oscar.apps.dashboard.reports.apps.ReportsDashboardConfig', 
                'oscar.apps.dashboard.users.apps.UsersDashboardConfig', 
                'oscar.apps.dashboard.orders.apps.OrdersDashboardConfig', 
                'oscar.apps.dashboard.catalogue.apps.CatalogueDashboardConfig', 
                'oscar.apps.dashboard.offers.apps.OffersDashboardConfig', 
                'oscar.apps.dashboard.partners.apps.PartnersDashboardConfig', 
                'oscar.apps.dashboard.pages.apps.PagesDashboardConfig', 
                'oscar.apps.dashboard.ranges.apps.RangesDashboardConfig', 
                'oscar.apps.dashboard.reviews.apps.ReviewsDashboardConfig', 
                'oscar.apps.dashboard.vouchers.apps.VouchersDashboardConfig', 
                'oscar.apps.dashboard.communications.apps.CommunicationsDashboardConfig', 
                'oscar.apps.dashboard.shipping.apps.ShippingDashboardConfig', 
                'haystack', 
                'treebeard', 
                'django_tables2', 
                'Iuno.shop', 
                'Iuno.shop.promotions', 
                'Iuno.shop.dashboard_promotions', 
                'ckeditor', 
                'ckeditor_uploader'
            ],
        }
        
        self.assertListEqual(settingsContent['INSTALLED_APPS'],
                             installedAppsSettings['INSTALLED_APPS'])

if __name__ == "__main__":
    testAttachSettings = TestAttachSettings()
    testAttachSettings.runTest()