#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11686 2019-08-21 04:00:34Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-08-21 13:00:34 +0900 (週三, 21 八月 2019) $
# $Revision: 11686 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class AdminPlaceholder(models.Model):
    name = models.CharField(_("Name"), max_length=20, editable=False, null=True)
    fromUrl = models.CharField(max_length=400, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True,
    )
    text = models.TextField(_("Text"))
    useGlobalAdminPlaceholder = models.BooleanField(
        _("Use Global AdminPlaceholder Value"), default=False)
        
    def __unicode__(self):
        return u"AdminPlaceholder: %d" % (self.id,)
        
        
class BlockDisplayControl(models.Model):
    name = models.CharField(_("Name"), max_length=20, editable=False, null=True)
    fromUrl = models.CharField(max_length=400, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True
    )
    display = models.BooleanField(_("Display"), default=True)
    useGlobalBlockDisplayControl = models.BooleanField(
        _("Use Global BlockDisplayControl Value"), default=False)
        
    def __unicode__(self):
        return u"BlockDisplayControl: %d" % (self.id,)
