#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11629 2019-06-11 17:44:34Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-12 02:44:34 +0900 (週三, 12 六月 2019) $
# $Revision: 11629 $

import json
import requests
import urllib

import six

from django.utils.http import urlquote
from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

if six.PY3:
    from urllib.parse import urlparse
else:
    from urlparse import urlparse

class Settings(object):
    # Facebook Nuwa Blog APP
    ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID = "1435073943305111"
    ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET = "1f0ba7a626695ee0c5419627c2d0a8b9"
    ZEPHYRUS_FACEBOOK_WEBHOOK_VERIFY_TOKEN = "25025529"
    
    ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE = \
        "facebook/FacebookFanPlugin.html"
    ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE = \
        "facebook/FacebookPhotoPlugin.html"

    ZEPHYRUS_FACEBOOK_FAN_TEMPLATES = [
        (ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES = [
        (ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_FACEBOOK_FAN_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_FACEBOOK_FAN_TEMPLATES:
            if not ele[0] == "facebook/FacebookFanPlugin.html":
                ZEPHYRUS_FACEBOOK_FAN_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES:
            if not ele[0] == "facebook/FacebookPhotoPlugin.html":
                ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES.append(ele)

settings = Settings()

def getCommentURL(commentId, 
    key=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID, 
    value=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET):

    accessToken = '%s|%s' % (key, value)
    url = ("https://graph.facebook.com/v3.3/"
           "%s?fields=permalink_url&access_token=%s") % (commentId, accessToken)
    result = requests.get(url)
    data = json.loads(result.text)

    url = data.get("permalink_url")

    if url:
        url = urlparse(url)
        return "%s://%s%s" % (url.scheme, url.netloc, url.path)
    else:
        return None

def getAPIData(url, fieldName, 
    key=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID, 
    value=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET):

    accessToken = '%s|%s' % (key, value)
    
    apiUrl = (
        'https://graph.facebook.com/v3.3/'
        '?id=%s&fields=engagement&access_token=%s' % (
        urlquote(url), accessToken)
    )
    
    data = json.loads(requests.get(apiUrl).text)
    
    if fieldName == "comment_count":
        # comment_plugin_count
        fieldName = "comment_plugin_count"
        return data.get("engagement", {}).get(fieldName, None)
    if fieldName == "share_count":
        # like
        fieldName = 'reaction_count'
        reaction = data.get("engagement", {}).get(fieldName, 0)
        fieldName = "comment_count"
        comment = data.get("engagement", {}).get(fieldName, 0)
        fieldName = 'share_count'
        share = data.get("engagement", {}).get(fieldName, 0)
        return reaction + share + comment
    return data.get("engagement", {}).get(fieldName, None)

