#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 11720 2019-09-23 06:12:17Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-09-23 15:12:17 +0900 (週一, 23 九月 2019) $
# $Revision: 11720 $

import re

from django.conf import settings
from django.http import HttpResponse

from Iuppiter.DjangoUtil import DJANGO_VERSION
from Zephyrus.statistics.models import URL

if hasattr(settings, 'ZEPHYRUS_STATISTICS_URL_INCLUDE'):
    ZEPHYRUS_STATISTICS_URL_INCLUDE = settings.ZEPHYRUS_STATISTICS_URL_INCLUDE
else:
    ZEPHYRUS_STATISTICS_URL_INCLUDE = []

if hasattr(settings, 'ZEPHYRUS_STATISTICS_URL_EXCLUDE'):
    ZEPHYRUS_STATISTICS_URL_EXCLUDE = settings.ZEPHYRUS_STATISTICS_URL_EXCLUDE
else:
    ZEPHYRUS_STATISTICS_URL_EXCLUDE = [
        re.compile(r'^captcha/'),
        re.compile(r'^media/'),
        re.compile(r'^static/'),
        re.compile(r'admin/'),
    ]
    
class BasetatisticsMiddleware(object):
    def process_request(self, request):
        # match
        path2 = request.path[1:] # 去掉網址最前面的 /
        
        if ZEPHYRUS_STATISTICS_URL_INCLUDE:
            needRecord = False
            for pattern in ZEPHYRUS_STATISTICS_URL_INCLUDE:
                if pattern.search(path2):
                    needRecord = True
        else:
            # default 
            needRecord = True
        
        for pattern in ZEPHYRUS_STATISTICS_URL_EXCLUDE:
            if pattern.search(path2):
                needRecord = False

        # view count
        if needRecord:
            url = request.build_absolute_uri(request.path)
            obj, created = URL.objects.get_or_create(
                url=url,
            )
            obj.viewCount += 1
            obj.save()
        return None
 
    def process_response(self, request, response):
        return response

if DJANGO_VERSION >= 11100:
    class StatisticsMiddleware(BasetatisticsMiddleware):
        def __init__(self, get_response):
            self.get_response = get_response
            
        def __call__(self, request):
            return self.get_response(request)

        def process_exception(self, request, exception): 
            return HttpResponse(str(exception))
            
        
else:
    class StatisticsMiddleware(object):
        pass