#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ContextProcessors.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
# $Revision: 9579 $

from django.conf import settings

from emencia.django.newsletter.context_processors import media as _media

from Theophrastus.TheophrastusSettings import MEDIA_URL

def media(request):
    """
    Adds media-related context variables to the context.
    """
    context = {
        'THEOPHRASTUS_MEDIA_URL': MEDIA_URL,
        'ENABLE_INTEGRATION': settings.ENABLE_INTEGRATION
    }
    _context = _media(request)
    context.update(_context)
    return context
