#!/usr/bin/env python
# -*- coding: utf-8 -*-


from django.db import models
from django.core import exceptions
from django.contrib.auth import get_user_model
from django.utils.translation import gettext_lazy as _
from oscar.core.loading import get_model

UserAddress = get_model('address', 'UserAddress')

TEXT = "text"
INTEGER = "integer"
BOOLEAN = "boolean"
FLOAT = "float"
RICHTEXT = "richtext"
DATE = "date"
DATETIME = "datetime"
OPTION = "option"
MULTI_OPTION = "multi_option"
ENTITY = "entity"
FILE = "file"
IMAGE = "image"
TYPE_CHOICES = (
    (TEXT, _("Text")),
    (INTEGER, _("Integer")),
    (BOOLEAN, _("True / False")),
    (FLOAT, _("Float")),
    (RICHTEXT, _("Rich Text")),
    (DATE, _("Date")),
    (DATETIME, _("Datetime")),
    (OPTION, _("Option")),
    #(MULTI_OPTION, _("Multi Option")),
    #(ENTITY, _("Entity")),
    (FILE, _("File")),
    (IMAGE, _("Image")),
)

class OptionType(models.Model):
    option = models.ForeignKey(
        'catalogue.Option',
        on_delete=models.CASCADE,
        verbose_name=_("Option")
    )
    
    type = models.CharField(
        choices=TYPE_CHOICES, default=TYPE_CHOICES[0][0],
        max_length=20, verbose_name=_("Type"))
    optionGroup = models.ForeignKey(
        'catalogue.AttributeOptionGroup',
        blank=True,
        null=True,
        on_delete=models.CASCADE,
        related_name='productAttributes',
        verbose_name=_("Option Group"),
        help_text=_(
            'Select an option group if using type "Option" or "Multi Option"'))
            
class OrdererAddress(models.Model):
    user = models.ForeignKey(
        get_user_model(),
        related_name='orderer',
        verbose_name=_("Orderer"),
    )
    
    address = models.ForeignKey(
        'address.UserAddress',
        on_delete=models.CASCADE,
        related_name='ordererAddress',
        verbose_name=_("Orderer Address"),
    )
    
@property
def isOrdererAddress(self):
    orderAddress, created = OrdererAddress.objects.get_or_create(
        user=self.user,
        defaults={
            'address': self,
        }
    )
    if orderAddress.address == self:
        return True
    else:
        return False
        
UserAddress.isOrdererAddress = isOrdererAddress

class ECPayTrade(models.Model):
    merchantId = models.CharField(max_length=255)
    merchantTradeNo = models.CharField(max_length=255)
    tradeNo = models.CharField(max_length=255)
    
    tradeDate = models.DateTimeField()
    paymentDate = models.DateTimeField()
    
    tradeAmt = models.IntegerField()
    payAmt = models.IntegerField()
         
    rtnCode = models.CharField(max_length=255)
    rtnMsg = models.CharField(max_length=255)
    paymentType = models.CharField(max_length=255)
    simulatePaid = models.CharField(max_length=255)
    paymentTypeChargeFee = models.CharField(max_length=255)

class AllPayTrade(models.Model):
    merchantId = models.CharField(max_length=255)
    merchantTradeNo = models.CharField(max_length=255)
    tradeNo = models.CharField(max_length=255)
    
    tradeDate = models.DateTimeField()
    paymentDate = models.DateTimeField()
    
    tradeAmt = models.IntegerField()
    payAmt = models.IntegerField()
         
    rtnCode = models.CharField(max_length=255)
    rtnMsg = models.CharField(max_length=255)
    paymentType = models.CharField(max_length=255)
    simulatePaid = models.CharField(max_length=255)
    paymentTypeChargeFee = models.CharField(max_length=255)

class SpgatewayTrade(models.Model):
    merchantId = models.CharField(max_length=255)
    merchantTradeNo = models.CharField(max_length=255)
    tradeNo = models.CharField(max_length=255)   
    paymentDate = models.DateTimeField()
    paymentType = models.CharField(max_length=255) 
    tradeAmt = models.IntegerField()
    rtnMsg = models.CharField(max_length=255)
    
    paymentMethod = models.CharField(max_length=255, null=True)
    rtnCode = models.CharField(max_length=255, null=True)
    
class CathaybkCreditTrade(models.Model):
    merchantId = models.CharField(max_length=255) # STOREID
    merchantTradeNo = models.CharField(max_length=255) # ORDERNUMBER
    tradeNo = models.CharField(max_length=255) # AUTHCODE
    
    paymentDate = models.DateTimeField() # AUTHTIME
    
    tradeAmt = models.IntegerField() # AMOUNT
         
    rtnCode = models.CharField(max_length=255) # AUTHSTATUS
    rtnMsg = models.CharField(max_length=255) # AUTHMSG
    cardNo = models.CharField(max_length=255) # CARDNO

class ECPayLogisticTrade(models.Model):
    # B2C & C2C
    merchantId = models.CharField(max_length=255) # MerchantID
    merchantTradeNo = models.CharField(max_length=255) # MerchantTradeNo
    tradeNo = models.CharField(max_length=255) # AllPayLogisticsID
    
    tradeDate = models.DateTimeField()
    updateStatusDate = models.DateTimeField() # UpdateStatusDate
    
    tradeAmt = models.IntegerField() # GoodsAmount
         
    rtnCode = models.CharField(max_length=255) # RtnCode
    rtnMsg = models.CharField(max_length=255) # RtnMsg

    receiverName = models.CharField(max_length=255) # ReceiverName
    receiverCellPhone = models.CharField(max_length=255) # ReceiverCellPhone
    receiverEmail = models.CharField(max_length=255, null=True) # ReceiverEmail

    logisticsType = models.CharField(max_length=255) # LogisticsType
    logisticsSubType = models.CharField(max_length=255) # LogisticsSubType

    # return
    rtnMerchantTradeNo = models.CharField(max_length=255, null=True)
    rtnOrderNo = models.CharField(max_length=255, null=True)

    # CVS C2C
    paymentNo = models.CharField(max_length=255, null=True) # CVSPaymentNo 
    validationNo = models.CharField(max_length=255, null=True) # CVSValidationNo 
    
