#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: BoilerplateTags.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

import os

from django import template
from django.utils.safestring import mark_safe
from django.conf import settings

register = template.Library()

from Iuno.shop.models import (
    OptionType, FILE, IMAGE, TEXT
)

@register.simple_tag(takes_context=True)
def getOptionType(context, option):
    ot, created = OptionType.objects.get_or_create(
        option=option,
        defaults={
            'type': TEXT, 
            'optionGroup': None,
        }
    )
    return ot

@register.simple_tag(takes_context=True)
def getLineAttributeValue(context, attribute):
    ot, created = OptionType.objects.get_or_create(
        option=attribute.option,
        defaults={
            'type': TEXT, 
            'optionGroup': None,
        }
    )
    if ot.type in [FILE, IMAGE]:
        if attribute.value:
            uploadPath = os.path.join(
                settings.MEDIA_URL, attribute.value)
            fileName = os.path.basename(uploadPath)
            val = "<a href='%s'>%s</a>" % (
                uploadPath.replace("\\", "/"), fileName)
            val = mark_safe(val)
        else:
            val = attribute.value
    else:
        val = attribute.value
        
    
    return val